/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.compuware.ispw.restapi.HttpMode;
import com.compuware.ispw.restapi.HttpRequestGlobalConfig;
import com.compuware.ispw.restapi.IspwRequestBean;
import com.compuware.ispw.restapi.IspwRestApiRequest;
import com.compuware.ispw.restapi.IspwRestApiRequestStep;
import com.compuware.ispw.restapi.ResponseContentSupplier;
import com.compuware.ispw.restapi.ResponseHandle;
import com.compuware.ispw.restapi.WebhookToken;
import com.compuware.ispw.restapi.action.IAction;
import com.compuware.ispw.restapi.auth.Authenticator;
import com.compuware.ispw.restapi.auth.CredentialBasicAuthentication;
import com.compuware.ispw.restapi.util.HttpClientUtil;
import com.compuware.ispw.restapi.util.HttpRequestNameValuePair;
import com.compuware.ispw.restapi.util.ReflectUtils;
import com.compuware.ispw.restapi.util.RequestAction;
import com.compuware.ispw.restapi.util.RestApiUtils;
import com.google.common.collect.Range;
import com.google.common.io.ByteStreams;
import hudson.AbortException;
import hudson.CloseProofOutputStream;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.remoting.RemoteOutputStream;
import hudson.security.ACL;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import jenkins.security.MasterToSlaveCallable;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class HttpRequestExecution
extends MasterToSlaveCallable<ResponseContentSupplier, RuntimeException> {
    private static final long serialVersionUID = -2066857816168989599L;
    private final String url;
    private final HttpMode httpMode;
    private final boolean ignoreSslErrors;
    private final HttpHost httpProxy;
    private final String body;
    private final List<HttpRequestNameValuePair> headers;
    private final String validResponseCodes;
    private final String validResponseContent;
    private final FilePath outputFile;
    private final int timeout;
    private final boolean consoleLogResponseBody;
    private final ResponseHandle responseHandle;
    private final Authenticator authenticator;
    private final OutputStream remoteLogger;
    private transient PrintStream localLogger;

    static HttpRequestExecution createPoller(String setId, IspwRestApiRequest http, EnvVars envVars, AbstractBuild<?, ?> build, TaskListener taskListener) throws AbortException {
        return HttpRequestExecution.createPoller(setId, null, http, envVars, build, taskListener);
    }

    static HttpRequestExecution createPoller(String setId, String level, IspwRestApiRequest http, EnvVars envVars, AbstractBuild<?, ?> build, TaskListener taskListener) throws AbortException {
        return HttpRequestExecution.createPoller(setId, level, null, http, envVars, build, taskListener);
    }

    static HttpRequestExecution createPoller(String setId, String level, WebhookToken webhookToken, IspwRestApiRequest http, EnvVars envVars, AbstractBuild<?, ?> build, TaskListener taskListener) throws AbortException {
        PrintStream logger = taskListener.getLogger();
        IAction action = ReflectUtils.createAction("GetSetInfo", logger);
        String cesUrl = RestApiUtils.getCesUrl(http.getConnectionId(), logger);
        String cesIspwHost = RestApiUtils.getIspwHostLabel(http.getConnectionId());
        String cesIspwToken = RestApiUtils.getCesToken(http.getCredentialsId(), (Item)build.getParent());
        if (RestApiUtils.isIspwDebugMode()) {
            logger.println("...ces.url=" + cesUrl + ", ces.ispw.host=" + cesIspwHost + ", ces.ispw.token=" + cesIspwToken);
        }
        String reqBody = "setId=" + setId;
        if (StringUtils.isNotBlank((CharSequence)level)) {
            reqBody = reqBody + System.lineSeparator() + "level=" + level;
        }
        IspwRequestBean ispwRequestBean = action.getIspwRequestBean(cesIspwHost, reqBody, webhookToken);
        String url = cesUrl + ispwRequestBean.getContextPath();
        String body = ispwRequestBean.getJsonRequest();
        List<HttpRequestNameValuePair> headers = http.resolveHeaders(envVars);
        FilePath outputFile = http.resolveOutputFile(envVars, build);
        AbstractProject project = build.getProject();
        return new HttpRequestExecution(url, HttpMode.GET, http.getIgnoreSslErrors(), http.getHttpProxy(), body, headers, http.getTimeout(), http.getAuthentication(), http.getValidResponseCodes(), http.getValidResponseContent(), http.getConsoleLogResponseBody(), outputFile, ResponseHandle.STRING, (Item)project, taskListener.getLogger());
    }

    static HttpRequestExecution createPoller(String setId, IspwRestApiRequestStep step, TaskListener taskListener, IspwRestApiRequestStep.Execution execution) throws AbortException {
        return HttpRequestExecution.createPoller(setId, null, null, step, taskListener, execution);
    }

    static HttpRequestExecution createPoller(String setId, String level, IspwRestApiRequestStep step, TaskListener taskListener, IspwRestApiRequestStep.Execution execution) throws AbortException {
        return HttpRequestExecution.createPoller(setId, level, null, step, taskListener, execution);
    }

    static HttpRequestExecution createPoller(String setId, String level, WebhookToken webhookToken, IspwRestApiRequestStep step, TaskListener taskListener, IspwRestApiRequestStep.Execution execution) throws AbortException {
        PrintStream logger = taskListener.getLogger();
        IAction action = ReflectUtils.createAction("GetSetInfo", logger);
        String cesUrl = RestApiUtils.getCesUrl(step.getConnectionId(), logger);
        String cesIspwHost = RestApiUtils.getIspwHostLabel(step.getConnectionId());
        String cesIspwToken = RestApiUtils.getCesToken(step.getCredentialsId(), execution.getProject());
        if (RestApiUtils.isIspwDebugMode()) {
            logger.println("...ces.url=" + cesUrl + ", ces.ispw.host=" + cesIspwHost + ", ces.ispw.token=" + cesIspwToken);
        }
        String reqBody = "setId=" + setId;
        if (StringUtils.isNotBlank((CharSequence)level)) {
            reqBody = reqBody + System.lineSeparator() + "level=" + level;
        }
        IspwRequestBean ispwRequestBean = action.getIspwRequestBean(cesIspwHost, reqBody, webhookToken);
        String url = cesUrl + ispwRequestBean.getContextPath();
        String body = ispwRequestBean.getJsonRequest();
        List<HttpRequestNameValuePair> headers = step.resolveHeaders();
        FilePath outputFile = execution.resolveOutputFile();
        Item project = execution.getProject();
        return new HttpRequestExecution(url, HttpMode.GET, step.isIgnoreSslErrors(), step.getHttpProxy(), body, headers, step.getTimeout(), step.getAuthentication(), step.getValidResponseCodes(), step.getValidResponseContent(), step.getConsoleLogResponseBody(), outputFile, step.getResponseHandle(), project, taskListener.getLogger());
    }

    static HttpRequestExecution from(IspwRestApiRequest http, EnvVars envVars, AbstractBuild<?, ?> build, TaskListener taskListener) {
        try {
            String url = http.resolveUrl(envVars, build, taskListener);
            String body = http.resolveBody(envVars, build, taskListener);
            List<HttpRequestNameValuePair> headers = http.resolveHeaders(envVars);
            FilePath outputFile = http.resolveOutputFile(envVars, build);
            AbstractProject project = build.getProject();
            return new HttpRequestExecution(url, http.getHttpMode(), http.getIgnoreSslErrors(), http.getHttpProxy(), body, headers, http.getTimeout(), http.getAuthentication(), http.getValidResponseCodes(), http.getValidResponseContent(), http.getConsoleLogResponseBody(), outputFile, ResponseHandle.NONE, (Item)project, taskListener.getLogger());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    static HttpRequestExecution from(IspwRestApiRequestStep step, TaskListener taskListener, IspwRestApiRequestStep.Execution execution) {
        List<HttpRequestNameValuePair> headers = step.resolveHeaders();
        FilePath outputFile = execution.resolveOutputFile();
        Item project = execution.getProject();
        return new HttpRequestExecution(step.getUrl(), step.getHttpMode(), step.isIgnoreSslErrors(), step.getHttpProxy(), step.getRequestBody(), headers, step.getTimeout(), step.getAuthentication(), step.getValidResponseCodes(), step.getValidResponseContent(), step.getConsoleLogResponseBody(), outputFile, step.getResponseHandle(), project, taskListener.getLogger());
    }

    private HttpRequestExecution(String url, HttpMode httpMode, boolean ignoreSslErrors, String httpProxy, String body, List<HttpRequestNameValuePair> headers, Integer timeout, String authentication, String validResponseCodes, String validResponseContent, Boolean consoleLogResponseBody, FilePath outputFile, ResponseHandle responseHandle, Item project, PrintStream logger) {
        this.url = url;
        this.httpMode = httpMode;
        this.ignoreSslErrors = ignoreSslErrors;
        this.httpProxy = StringUtils.isNotBlank((CharSequence)httpProxy) ? HttpHost.create((String)httpProxy) : null;
        this.body = body;
        this.headers = headers;
        int n = this.timeout = timeout != null ? timeout : -1;
        if (authentication != null && !authentication.isEmpty()) {
            StandardUsernamePasswordCredentials credential;
            Authenticator auth = HttpRequestGlobalConfig.get().getAuthentication(authentication);
            if (auth == null && (credential = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)url).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)authentication))) != null) {
                auth = new CredentialBasicAuthentication(credential);
            }
            if (auth == null) {
                throw new IllegalStateException("Authentication '" + authentication + "' doesn't exist anymore");
            }
            this.authenticator = auth;
        } else {
            this.authenticator = null;
        }
        this.validResponseCodes = validResponseCodes;
        this.validResponseContent = validResponseContent != null ? validResponseContent : "";
        this.consoleLogResponseBody = Boolean.TRUE.equals(consoleLogResponseBody);
        this.responseHandle = ResponseHandle.STRING;
        this.outputFile = outputFile;
        this.localLogger = logger;
        this.remoteLogger = new RemoteOutputStream((OutputStream)new CloseProofOutputStream((OutputStream)logger));
    }

    public ResponseContentSupplier call() throws RuntimeException {
        if (RestApiUtils.isIspwDebugMode()) {
            this.logger().println("HttpMethod: " + (Object)((Object)this.httpMode));
            this.logger().println("URL: " + this.url);
            for (HttpRequestNameValuePair header : this.headers) {
                this.logger().print(header.getName() + ": ");
                this.logger().println(header.getMaskValue() ? "*****" : header.getValue());
            }
        }
        try {
            return this.authAndRequest();
        }
        catch (IOException | InterruptedException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private PrintStream logger() {
        if (this.localLogger == null) {
            try {
                this.localLogger = new PrintStream(this.remoteLogger, true, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.localLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseContentSupplier authAndRequest() throws IOException, InterruptedException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        ResponseHandle responseHandle = ResponseHandle.NONE;
        CloseableHttpClient httpclient = null;
        try {
            HttpClientBuilder clientBuilder = HttpClientBuilder.create().useSystemProperties();
            this.configureTimeoutAndSsl(clientBuilder);
            if (this.httpProxy != null) {
                clientBuilder.setProxy(this.httpProxy);
            }
            HttpClientUtil clientUtil = new HttpClientUtil();
            HttpRequestBase httpRequestBase = clientUtil.createRequestBase(new RequestAction(new URL(this.url), this.httpMode, this.body, null, this.headers));
            BasicHttpContext context = new BasicHttpContext();
            httpclient = this.auth(clientBuilder, httpRequestBase, (HttpContext)context);
            ResponseContentSupplier response = this.executeRequest(httpclient, clientUtil, httpRequestBase, (HttpContext)context);
            this.processResponse(response);
            responseHandle = this.responseHandle;
            if (responseHandle == ResponseHandle.LEAVE_OPEN) {
                response.setHttpClient(httpclient);
            }
            ResponseContentSupplier responseContentSupplier = response;
            return responseContentSupplier;
        }
        finally {
            if (responseHandle != ResponseHandle.LEAVE_OPEN && httpclient != null) {
                httpclient.close();
            }
        }
    }

    private void configureTimeoutAndSsl(HttpClientBuilder clientBuilder) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        if (this.timeout > 0) {
            int t = this.timeout * 1000;
            RequestConfig config = RequestConfig.custom().setSocketTimeout(t).setConnectTimeout(t).setConnectionRequestTimeout(t).build();
            clientBuilder.setDefaultRequestConfig(config);
        }
        if (this.ignoreSslErrors) {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, new TrustManager[]{new NoopTrustManager()}, new SecureRandom());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sc, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        }
    }

    private CloseableHttpClient auth(HttpClientBuilder clientBuilder, HttpRequestBase httpRequestBase, HttpContext context) throws IOException, InterruptedException {
        if (this.authenticator == null) {
            return clientBuilder.build();
        }
        this.logger().println("Using authentication: " + this.authenticator.getKeyName());
        return this.authenticator.authenticate(clientBuilder, context, httpRequestBase, this.logger());
    }

    private ResponseContentSupplier executeRequest(CloseableHttpClient httpclient, HttpClientUtil clientUtil, HttpRequestBase httpRequestBase, HttpContext context) throws IOException, InterruptedException {
        ResponseContentSupplier responseContentSupplier;
        try {
            HttpResponse response = clientUtil.execute((HttpClient)httpclient, context, httpRequestBase, this.logger());
            responseContentSupplier = new ResponseContentSupplier(this.responseHandle, response);
        }
        catch (UnknownHostException uhe) {
            this.logger().println("Treating UnknownHostException(" + uhe.getMessage() + ") as 404 Not Found");
            responseContentSupplier = new ResponseContentSupplier("UnknownHostException as 404 Not Found", 404);
        }
        catch (ConnectException | SocketTimeoutException ce) {
            this.logger().println("Treating " + ce.getClass() + "(" + ce.getMessage() + ") as 408 Request Timeout");
            responseContentSupplier = new ResponseContentSupplier(ce.getClass() + "(" + ce.getMessage() + ") as 408 Request Timeout", 408);
        }
        return responseContentSupplier;
    }

    private void responseCodeIsValid(ResponseContentSupplier response) throws AbortException {
        List<Range<Integer>> ranges = IspwRestApiRequest.DescriptorImpl.parseToRange(this.validResponseCodes);
        for (Range<Integer> range : ranges) {
            if (!range.contains((Comparable)Integer.valueOf(response.getStatus()))) continue;
            if (RestApiUtils.isIspwDebugMode()) {
                this.logger().println("Success code from " + range);
            }
            return;
        }
        throw new AbortException("Fail: the returned code " + response.getStatus() + " is not in the accepted range: " + ranges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponse(ResponseContentSupplier response) throws IOException, InterruptedException {
        if (this.consoleLogResponseBody) {
            this.logger().println("Response: \n" + response.getContent());
        }
        try {
            this.responseCodeIsValid(response);
            if (!this.validResponseContent.isEmpty() && !response.getContent().contains(this.validResponseContent)) {
                throw new AbortException("Fail: Response doesn't contain expected content '" + this.validResponseContent + "'");
            }
        }
        catch (AbortException x) {
            if (RestApiUtils.logMessageIfAny(this.logger(), response, true)) {
                response.setAbortStatus(true);
                response.setAbortMessage(x.getMessage());
            }
            this.logger().println(x.getMessage());
            throw x;
        }
        if (this.outputFile == null) {
            return;
        }
        this.logger().println("Saving response body to " + this.outputFile);
        InputStream in = response.getContentStream();
        if (in == null) {
            return;
        }
        OutputStream out = null;
        try {
            out = this.outputFile.write();
            ByteStreams.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            if (out != null) {
                out.close();
            }
            in.close();
        }
    }

    public static HttpRequestExecution createTaskInfoPoller(String setId, IspwRestApiRequest http, EnvVars envVars, AbstractBuild<?, ?> build, BuildListener taskListener) throws AbortException {
        PrintStream logger = taskListener.getLogger();
        IAction action = ReflectUtils.createAction("GetSetTaskList", logger);
        String cesUrl = RestApiUtils.getCesUrl(http.getConnectionId(), logger);
        String cesIspwHost = RestApiUtils.getIspwHostLabel(http.getConnectionId());
        String cesIspwToken = RestApiUtils.getCesToken(http.getCredentialsId(), (Item)build.getParent());
        if (RestApiUtils.isIspwDebugMode()) {
            logger.println("...ces.url=" + cesUrl + ", ces.ispw.host=" + cesIspwHost + ", ces.ispw.token=" + cesIspwToken);
        }
        IspwRequestBean ispwRequestBean = action.getIspwRequestBean(cesIspwHost, "setId=" + setId, null);
        String url = cesUrl + ispwRequestBean.getContextPath();
        String body = ispwRequestBean.getJsonRequest();
        List<HttpRequestNameValuePair> headers = http.resolveHeaders(envVars);
        FilePath outputFile = http.resolveOutputFile(envVars, build);
        AbstractProject project = build.getProject();
        return new HttpRequestExecution(url, HttpMode.GET, http.getIgnoreSslErrors(), http.getHttpProxy(), body, headers, http.getTimeout(), http.getAuthentication(), http.getValidResponseCodes(), http.getValidResponseContent(), http.getConsoleLogResponseBody(), outputFile, ResponseHandle.STRING, (Item)project, taskListener.getLogger());
    }

    public static HttpRequestExecution createTaskInfoPoller(String setId, IspwRestApiRequestStep step, TaskListener taskListener, IspwRestApiRequestStep.Execution execution) throws AbortException {
        PrintStream logger = taskListener.getLogger();
        IAction action = ReflectUtils.createAction("GetSetTaskList", logger);
        String cesUrl = RestApiUtils.getCesUrl(step.getConnectionId(), logger);
        String cesIspwHost = RestApiUtils.getIspwHostLabel(step.getConnectionId());
        String cesIspwToken = RestApiUtils.getCesToken(step.getCredentialsId(), execution.getProject());
        if (RestApiUtils.isIspwDebugMode()) {
            logger.println("...ces.url=" + cesUrl + ", ces.ispw.host=" + cesIspwHost + ", ces.ispw.token=" + cesIspwToken);
        }
        IspwRequestBean ispwRequestBean = action.getIspwRequestBean(cesIspwHost, "setId=" + setId, null);
        String url = cesUrl + ispwRequestBean.getContextPath();
        String body = ispwRequestBean.getJsonRequest();
        List<HttpRequestNameValuePair> headers = step.resolveHeaders();
        FilePath outputFile = execution.resolveOutputFile();
        Item project = execution.getProject();
        return new HttpRequestExecution(url, HttpMode.GET, step.isIgnoreSslErrors(), step.getHttpProxy(), body, headers, step.getTimeout(), step.getAuthentication(), step.getValidResponseCodes(), step.getValidResponseContent(), step.getConsoleLogResponseBody(), outputFile, step.getResponseHandle(), project, taskListener.getLogger());
    }

    private static class NoopTrustManager
    extends X509ExtendedTrustManager {
        private NoopTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        }
    }
}

