/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.git;

import com.compuware.ispw.git.BranchPatternMatcher;
import com.compuware.ispw.git.GitToIspwUtils;
import com.compuware.ispw.git.IGitToIspwPublish;
import com.compuware.ispw.git.RefMap;
import com.compuware.ispw.restapi.util.RestApiUtils;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import hudson.util.ListBoxModel;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import jenkins.branch.BranchIndexingCause;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class GitToIspwPublishStep
extends AbstractStepImpl
implements IGitToIspwPublish {
    private String gitRepoUrl = "";
    private String gitCredentialsId = "";
    private String connectionId = "";
    private String credentialsId = "";
    private String runtimeConfig = "";
    private String stream = "";
    private String app = "";
    private String ispwConfigPath = "";
    private String branchMapping = "#The following comments show how to use the 'Branch Mapping' field.\n#Click on the help button to the right of the screen for more details on how to populate this field\n#\n#**/dev1 => DEV1, per-commit\n#**/dev2 => DEV2, per-branch\n#**/dev3 => DEV3, custom, a description\n";

    @DataBoundConstructor
    public GitToIspwPublishStep() {
    }

    @Initializer(before=InitMilestone.PLUGINS_STARTED)
    public static void xStreamCompatibility() {
    }

    @Override
    public String getGitRepoUrl() {
        return this.gitRepoUrl;
    }

    @DataBoundSetter
    public void setGitRepoUrl(String gitRepoUrl) {
        this.gitRepoUrl = gitRepoUrl;
    }

    @Override
    public String getGitCredentialsId() {
        return this.gitCredentialsId;
    }

    @DataBoundSetter
    public void setGitCredentialsId(String gitCredentialsId) {
        this.gitCredentialsId = gitCredentialsId;
    }

    @Override
    public String getConnectionId() {
        return this.connectionId;
    }

    @DataBoundSetter
    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    @Override
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @Override
    public String getRuntimeConfig() {
        return this.runtimeConfig;
    }

    @DataBoundSetter
    public void setRuntimeConfig(String runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    @Override
    public String getStream() {
        return this.stream;
    }

    @DataBoundSetter
    public void setStream(String stream) {
        this.stream = stream;
    }

    @Override
    public String getApp() {
        return this.app;
    }

    @DataBoundSetter
    public void setApp(String app) {
        this.app = app;
    }

    public String getBranchMapping() {
        return this.branchMapping;
    }

    @DataBoundSetter
    public void setBranchMapping(String branchMapping) {
        this.branchMapping = branchMapping;
    }

    @Override
    public String getIspwConfigPath() {
        return this.ispwConfigPath;
    }

    @DataBoundSetter
    public void setIspwConfigPath(String ispwConfigPath) {
        this.ispwConfigPath = ispwConfigPath;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public static final String gitRepoUrl = "";
        public static final String gitCredentialsId = "";
        public static final String connectionId = "";
        public static final String credentialsId = "";
        public static final String runtimeConfig = "";
        public static final String stream = "";
        public static final String app = "";
        public static final String ispwConfigPath = "";
        public static final String branchMapping = "#The following comments show how to use the 'Branch Mapping' field.\n#Click on the help button to the right of the screen for more details on how to populate this field\n#\n#**/dev1 => DEV1, per-commit\n#**/dev2 => DEV2, per-branch\n#**/dev3 => DEV3, custom, a description\n";
        public static final String containerDesc = "";
        public static final String containerPref = "";

        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getDisplayName() {
            return "Git to ISPW Integration";
        }

        public String getFunctionName() {
            return "gitToIspwIntegration";
        }

        public ListBoxModel doFillGitCredentialsIdItems(@AncestorInPath Jenkins context, @QueryParameter String gitCredentialsId, @AncestorInPath Item project) {
            return GitToIspwUtils.buildStandardCredentialsIdItems(context, gitCredentialsId, project);
        }

        public ListBoxModel doFillConnectionIdItems(@AncestorInPath Jenkins context, @QueryParameter String connectionId, @AncestorInPath Item project) {
            return RestApiUtils.buildConnectionIdItems(context, connectionId, project);
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Jenkins context, @QueryParameter String credentialsId, @AncestorInPath Item project) {
            return GitToIspwUtils.buildStandardCredentialsIdItems(context, credentialsId, project);
        }
    }

    public static final class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Integer> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient GitToIspwPublishStep step;
        @StepContextParameter
        private transient Run<?, ?> run;
        @StepContextParameter
        private transient TaskListener listener;

        protected Integer run() throws Exception {
            FilePath buildParmPath;
            boolean firstBuild = false;
            WorkflowRun workflowRun = null;
            WorkflowRun previousRun = null;
            PrintStream logger = this.listener.getLogger();
            EnvVars envVars = (EnvVars)this.getContext().get(EnvVars.class);
            GitToIspwUtils.trimEnvironmentVariables(envVars);
            FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
            List<? extends ChangeLogSet<? extends ChangeLogSet.Entry>> changeSets = GitToIspwUtils.getChangeSets(this.run, logger);
            String branchName = envVars.get("BRANCH_NAME", "");
            boolean calculatLog = false;
            if (this.run instanceof WorkflowRun) {
                workflowRun = (WorkflowRun)this.run;
                previousRun = workflowRun.getPreviousBuild();
            }
            if (this.run instanceof WorkflowRun && (changeSets == null || changeSets.isEmpty()) && previousRun != null && GitToIspwUtils.isReCalculateChangesRequired(workflowRun, this.listener)) {
                if (RestApiUtils.isIspwDebugMode()) {
                    logger.println("GitToIspwPublishStep: Calculate the changelog when re-running the last build.");
                }
                calculatLog = true;
            }
            if ((buildParmPath = GitToIspwUtils.getFilePathInVirtualWorkspace(envVars, "automaticBuildParams.txt")).exists()) {
                logger.println("Remove the old build parm files." + buildParmPath.getName());
                buildParmPath.delete();
            }
            if ((changeSets != null || calculatLog) && !branchName.isEmpty()) {
                HashSet<String> changedPathSet = new HashSet<String>();
                String paths = null;
                logger.println("Branch name: " + branchName);
                Iterator<Object> itrChangeSets = changeSets.iterator();
                if (calculatLog) {
                    if (RestApiUtils.isIspwDebugMode()) {
                        logger.println("GitToIspwPublishStep: Calculate the change log. ");
                    }
                    itrChangeSets = GitToIspwUtils.calculateGitSCMChanges(this.run, workspace, this.listener, envVars).iterator();
                }
                if (!itrChangeSets.hasNext()) {
                    if (previousRun == null) {
                        List causes = this.run.getCauses();
                        for (int i = 0; i < causes.size(); ++i) {
                            if (!(causes.get(i) instanceof BranchIndexingCause)) continue;
                            firstBuild = true;
                            break;
                        }
                    }
                    if (!firstBuild) {
                        logger.println("No changed files were detected.");
                        return 0;
                    }
                }
                while (itrChangeSets.hasNext()) {
                    ChangeLogSet<? extends ChangeLogSet.Entry> changeLogSets = itrChangeSets.next();
                    for (ChangeLogSet.Entry changeLogSet : changeLogSets) {
                        logger.println("Commit ID = " + changeLogSet.getCommitId());
                        Collection affectedFiles = changeLogSet.getAffectedFiles();
                        for (ChangeLogSet.AffectedFile affectedFile : affectedFiles) {
                            String affectedPath = affectedFile.getPath();
                            if (affectedFile.getEditType() == EditType.DELETE) {
                                affectedPath = "|" + changeLogSet.getCommitId() + "|" + affectedPath;
                            }
                            changedPathSet.add(affectedPath);
                            if (!RestApiUtils.isIspwDebugMode()) continue;
                            logger.println("GitToIspwPublishStep: add a file path - " + affectedPath);
                        }
                    }
                    logger.println("ChangedPathSet = " + changedPathSet);
                    if (changedPathSet.isEmpty()) {
                        logger.println("No changed files were detected.");
                        return 0;
                    }
                    HashSet<String> pathSet = changedPathSet;
                    paths = StringUtils.join(pathSet, (String)":");
                    if (firstBuild) continue;
                    envVars.put("toHash", paths);
                    envVars.put("fromHash", "-1");
                    envVars.put("ref", branchName);
                }
            }
            if (firstBuild) {
                envVars.put("toHash", "-2");
                envVars.put("fromHash", "-2");
                envVars.put("ref", branchName);
            }
            Map<String, RefMap> map = GitToIspwUtils.parse(this.step.branchMapping);
            if (RestApiUtils.isIspwDebugMode()) {
                logger.println("map=" + map);
            }
            String refId = envVars.get("refId", null);
            BranchPatternMatcher matcher = new BranchPatternMatcher(map, logger);
            String matchTo = null;
            RefMap refMap = null;
            if (StringUtils.isBlank((String)refId)) {
                logger.println("Using branch name for branch pattern match: " + branchName);
                matchTo = StringUtils.trimToNull((String)branchName);
            } else {
                logger.println("Using refid for branch pattern match: " + refId);
                matchTo = StringUtils.trimToNull((String)refId);
            }
            RestApiUtils.assertNotNull(logger, matchTo, "Cannot match on the branch name or refId in the branch mapping. Both are null or empty.");
            refMap = matcher.match(matchTo);
            RestApiUtils.assertNotNull(logger, refMap, "Cannot find a branch pattern that matches the branch %s.  Please adjust your branch mapping.", matchTo);
            Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
            if (GitToIspwUtils.callCli(launcher, this.run, logger, envVars, refMap, this.step)) {
                return 0;
            }
            throw new AbortException("An error occurred while synchronizing source to ISPW");
        }
    }
}

