/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.git;

import com.compuware.ispw.git.BranchPatternMatcher;
import com.compuware.ispw.git.GitToIspwUtils;
import com.compuware.ispw.git.IGitToIspwPublish;
import com.compuware.ispw.git.RefMap;
import com.compuware.ispw.restapi.util.RestApiUtils;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.scm.NullSCM;
import hudson.scm.SCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class GitToIspwPublish
extends Builder
implements IGitToIspwPublish {
    String gitRepoUrl = "";
    String gitCredentialsId = "";
    private String connectionId = "";
    private String credentialsId = "";
    private String runtimeConfig = "";
    private String stream = "";
    private String app = "";
    private String ispwConfigPath = "";
    private String branchMapping = "#The following comments show how to use the 'Branch Mapping' field.\n#Click on the help button to the right of the screen for more details on how to populate this field\n#\n#**/dev1 => DEV1, per-commit\n#**/dev2 => DEV2, per-branch\n#**/dev3 => DEV3, custom, a description\n";

    @DataBoundConstructor
    public GitToIspwPublish() {
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        AbstractProject project = build.getProject();
        SCM scm = project.getScm();
        if (!(scm instanceof GitSCM)) {
            if (scm instanceof NullSCM) {
                throw new AbortException("Jenkins Git Plugin SCM is required along with selecting the Git option in the Source Code Management section and providing the Git repository URL and credentials.");
            }
            throw new AbortException("The Git option must be selected in the Jenkins project Source Code Management section along with providing the Git repository URL and credentials. The Source Code Management section selection type is " + scm.getType());
        }
        GitSCM gitSCM = (GitSCM)scm;
        List userRemoteConfigs = gitSCM.getUserRemoteConfigs();
        this.gitRepoUrl = ((UserRemoteConfig)userRemoteConfigs.get(0)).getUrl();
        this.gitCredentialsId = ((UserRemoteConfig)userRemoteConfigs.get(0)).getCredentialsId();
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        GitToIspwUtils.trimEnvironmentVariables(envVars);
        Map<String, RefMap> map = GitToIspwUtils.parse(this.branchMapping);
        logger.println("branch mapping = " + map);
        String refId = envVars.get("refId", null);
        logger.println("branch name (refId) = " + refId);
        BranchPatternMatcher matcher = new BranchPatternMatcher(map, logger);
        RefMap refMap = matcher.match(refId);
        RestApiUtils.assertNotNull(logger, refMap, "Cannot find a branch pattern that matches the branch %s. Please adjust your branch mapping.", refId);
        String fromHash = envVars.get("fromHash", null);
        String toHash = envVars.get("toHash", null);
        if (fromHash != null && toHash != null) {
            toHash = toHash.replace("0", "");
            if ((fromHash = fromHash.replace("0", "")).isEmpty() && !toHash.isEmpty()) {
                envVars.put("fromHash", "-2");
            }
        }
        if (GitToIspwUtils.callCli(launcher, build, logger, envVars, refMap, this)) {
            return true;
        }
        logger.println("An error occurred while synchronizing source to ISPW");
        return false;
    }

    @Initializer(before=InitMilestone.PLUGINS_STARTED)
    public static void xStreamCompatibility() {
    }

    @Override
    public String getGitRepoUrl() {
        return this.gitRepoUrl;
    }

    @Override
    public String getGitCredentialsId() {
        return this.gitCredentialsId;
    }

    @Override
    public String getConnectionId() {
        return this.connectionId;
    }

    @DataBoundSetter
    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    @Override
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @Override
    public String getRuntimeConfig() {
        return this.runtimeConfig;
    }

    @DataBoundSetter
    public void setRuntimeConfig(String runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    @Override
    public String getStream() {
        return this.stream;
    }

    @DataBoundSetter
    public void setStream(String stream) {
        this.stream = stream;
    }

    @Override
    public String getApp() {
        return this.app;
    }

    @DataBoundSetter
    public void setApp(String app) {
        this.app = app;
    }

    public String getBranchMapping() {
        return this.branchMapping;
    }

    @DataBoundSetter
    public void setBranchMapping(String branchMapping) {
        this.branchMapping = branchMapping;
    }

    @Override
    public String getIspwConfigPath() {
        return this.ispwConfigPath;
    }

    @DataBoundSetter
    public void setIspwConfigPath(String ispwConfigPath) {
        this.ispwConfigPath = ispwConfigPath;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public static final String connectionId = "";
        public static final String credentialsId = "";
        public static final String runtimeConfig = "";
        public static final String stream = "";
        public static final String app = "";
        public static final String ispwConfigPath = "";
        public static final String branchMapping = "#The following comments show how to use the 'Branch Mapping' field.\n#Click on the help button to the right of the screen for more details on how to populate this field\n#\n#**/dev1 => DEV1, per-commit\n#**/dev2 => DEV2, per-branch\n#**/dev3 => DEV3, custom, a description\n";
        public static final String containerDesc = "";
        public static final String containerPref = "";

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Git to ISPW Integration";
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public ListBoxModel doFillGitCredentialsIdItems(@AncestorInPath Jenkins context, @QueryParameter String gitCredentialsId, @AncestorInPath Item project) {
            return GitToIspwUtils.buildStandardCredentialsIdItems(context, gitCredentialsId, project);
        }

        public ListBoxModel doFillConnectionIdItems(@AncestorInPath Jenkins context, @QueryParameter String connectionId, @AncestorInPath Item project) {
            return RestApiUtils.buildConnectionIdItems(context, connectionId, project);
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Jenkins context, @QueryParameter String credentialsId, @AncestorInPath Item project) {
            return GitToIspwUtils.buildStandardCredentialsIdItems(context, credentialsId, project);
        }
    }
}

