/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.git;

import hudson.model.Run;
import hudson.plugins.git.GitChangeSet;
import hudson.scm.ChangeLogSet;
import hudson.scm.RepositoryBrowser;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.kohsuke.stapler.export.Exported;

public class CustomGitChangeSetList
extends ChangeLogSet<ChangeLogSet.Entry> {
    private final List<ChangeLogSet.Entry> changeSets;

    public CustomGitChangeSetList(Run build, RepositoryBrowser<?> browser, List<GitChangeSet> logs) {
        super(build, browser);
        Collections.reverse(logs);
        this.changeSets = Collections.unmodifiableList(logs);
        for (GitChangeSet log : logs) {
            log.setParent((ChangeLogSet)this);
        }
    }

    public boolean isEmptySet() {
        return this.changeSets.isEmpty();
    }

    public Iterator<ChangeLogSet.Entry> iterator() {
        return this.changeSets.iterator();
    }

    public List<ChangeLogSet.Entry> getLogs() {
        return this.changeSets;
    }

    @Exported
    public String getKind() {
        return "git";
    }
}

