/*
 * Decompiled with CFR 0.152.
 */
package com.commercehub.gradle.plugin.avro;

import com.commercehub.gradle.plugin.avro.Constants;
import com.commercehub.gradle.plugin.avro.Enums;
import com.commercehub.gradle.plugin.avro.FileExtensionSpec;
import com.commercehub.gradle.plugin.avro.FileState;
import com.commercehub.gradle.plugin.avro.MapUtils;
import com.commercehub.gradle.plugin.avro.OutputDirTask;
import com.commercehub.gradle.plugin.avro.ProcessingState;
import com.commercehub.gradle.plugin.avro.SetBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.generic.GenericData;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.NotSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class GenerateAvroJavaTask
extends OutputDirTask {
    private static Pattern ERROR_UNKNOWN_TYPE = Pattern.compile("(?i).*(undefined name|not a defined name).*");
    private static Pattern ERROR_DUPLICATE_TYPE = Pattern.compile("Can't redefine: (.*)");
    private static Set<String> SUPPORTED_EXTENSIONS = SetBuilder.build("avpr", "avsc");
    private String outputCharacterEncoding;
    private String stringType = Constants.DEFAULT_STRING_TYPE;
    private String fieldVisibility = Constants.DEFAULT_FIELD_VISIBILITY;
    private String templateDirectory;
    private boolean createSetters = true;
    private transient GenericData.StringType parsedStringType;
    private transient SpecificCompiler.FieldVisibility parsedFieldVisibility;

    @Optional
    @Input
    public String getOutputCharacterEncoding() {
        return this.outputCharacterEncoding;
    }

    public void setOutputCharacterEncoding(String outputCharacterEncoding) {
        this.outputCharacterEncoding = outputCharacterEncoding;
    }

    public void setOutputCharacterEncoding(Charset outputCharacterEncoding) {
        this.setOutputCharacterEncoding(outputCharacterEncoding.name());
    }

    @Input
    public String getStringType() {
        return this.stringType;
    }

    public void setStringType(GenericData.StringType stringType) {
        this.setStringType(stringType.name());
    }

    public void setStringType(String stringType) {
        this.stringType = stringType;
    }

    @Input
    public String getFieldVisibility() {
        return this.fieldVisibility;
    }

    public void setFieldVisibility(String fieldVisibility) {
        this.fieldVisibility = fieldVisibility;
    }

    public void setFieldVisibility(SpecificCompiler.FieldVisibility fieldVisibility) {
        this.setFieldVisibility(fieldVisibility.name());
    }

    @Optional
    @Input
    public String getTemplateDirectory() {
        return this.templateDirectory;
    }

    public void setTemplateDirectory(String templateDirectory) {
        this.templateDirectory = templateDirectory;
    }

    @Input
    public boolean isCreateSetters() {
        return this.createSetters;
    }

    public void setCreateSetters(String createSetters) {
        this.createSetters = Boolean.parseBoolean(createSetters);
    }

    @TaskAction
    protected void process() {
        this.parsedStringType = (GenericData.StringType)Enums.parseCaseInsensitive((String)"stringType", (Enum[])GenericData.StringType.values(), (String)this.getStringType());
        this.parsedFieldVisibility = (SpecificCompiler.FieldVisibility)Enums.parseCaseInsensitive((String)"fieldVisibility", (Enum[])SpecificCompiler.FieldVisibility.values(), (String)this.getFieldVisibility());
        this.getLogger().debug("Using outputCharacterEncoding {}", (Object)this.getOutputCharacterEncoding());
        this.getLogger().debug("Using stringType {}", (Object)this.parsedStringType.name());
        this.getLogger().debug("Using fieldVisibility {}", (Object)this.parsedFieldVisibility.name());
        this.getLogger().debug("Using templateDirectory '{}'", (Object)this.getTemplateDirectory());
        this.getLogger().debug("Using createSetters {}", (Object)this.isCreateSetters());
        this.getLogger().info("Found {} files", (Object)this.getInputs().getSourceFiles().getFiles().size());
        this.failOnUnsupportedFiles();
        this.preClean();
        this.processFiles();
    }

    private void failOnUnsupportedFiles() {
        FileCollection unsupportedFiles = this.filterSources((Spec<? super File>)new NotSpec((Spec)new FileExtensionSpec(SUPPORTED_EXTENSIONS)));
        if (!unsupportedFiles.isEmpty()) {
            throw new GradleException(String.format("Unsupported file extension for the following files: %s", unsupportedFiles));
        }
    }

    private void preClean() {
        this.getProject().delete(new Object[]{this.getOutputDir()});
    }

    private void processFiles() {
        int processedFileCount = 0;
        processedFileCount += this.processProtoFiles();
        this.setDidWork((processedFileCount += this.processSchemaFiles()) > 0);
    }

    private int processProtoFiles() {
        int processedFileCount = 0;
        for (File sourceFile : this.filterSources(new FileExtensionSpec("avpr"))) {
            this.processProtoFile(sourceFile);
            ++processedFileCount;
        }
        return processedFileCount;
    }

    private void processProtoFile(File sourceFile) {
        this.getLogger().info("Processing {}", (Object)sourceFile);
        try {
            this.compile(Protocol.parse((File)sourceFile), sourceFile);
        }
        catch (IOException ex) {
            throw new GradleException(String.format("Failed to compile protocol definition file %s", sourceFile), (Throwable)ex);
        }
    }

    private int processSchemaFiles() {
        Set files = this.filterSources(new FileExtensionSpec("avsc")).getFiles();
        ProcessingState processingState = new ProcessingState(files, this.getProject());
        while (processingState.isWorkRemaining()) {
            this.processSchemaFile(processingState, processingState.nextFileState());
        }
        Set<FileState> failedFiles = processingState.getFailedFiles();
        if (!failedFiles.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder("Could not compile schema definition files:");
            for (FileState fileState : failedFiles) {
                String path = fileState.getPath();
                String fileErrorMessage = fileState.getErrorMessage();
                errorMessage.append(Constants.lineSeparator()).append("* ").append(path).append(": ").append(fileErrorMessage);
            }
            throw new GradleException(errorMessage.toString());
        }
        return processingState.getProcessedTotal();
    }

    private void processSchemaFile(ProcessingState processingState, FileState fileState) {
        String path = fileState.getPath();
        this.getLogger().debug("Processing {}, excluding types {}", (Object)path, fileState.getDuplicateTypeNames());
        File sourceFile = fileState.getFile();
        Map<String, Schema> parserTypes = processingState.determineParserTypes(fileState);
        try {
            Schema.Parser parser = new Schema.Parser();
            parser.addTypes(parserTypes);
            this.compile(parser.parse(sourceFile), sourceFile);
            Map<String, Schema> typesDefinedInFile = MapUtils.asymmetricDifference(parser.getTypes(), parserTypes);
            processingState.processTypeDefinitions(fileState, typesDefinedInFile);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Processed {}; contained types {}", (Object)path, typesDefinedInFile.keySet());
            } else {
                this.getLogger().info("Processed {}", (Object)path);
            }
        }
        catch (SchemaParseException ex) {
            String errorMessage = ex.getMessage();
            Matcher unknownTypeMatcher = ERROR_UNKNOWN_TYPE.matcher(errorMessage);
            Matcher duplicateTypeMatcher = ERROR_DUPLICATE_TYPE.matcher(errorMessage);
            if (unknownTypeMatcher.matches()) {
                fileState.setError(ex);
                processingState.queueForDelayedProcessing(fileState);
                this.getLogger().debug("Found undefined name in {} ({}); will try again", (Object)path, (Object)errorMessage);
            }
            if (duplicateTypeMatcher.matches()) {
                String typeName = duplicateTypeMatcher.group(1);
                fileState.setError(ex);
                fileState.addDuplicateTypeName(typeName);
                processingState.queueForProcessing(fileState);
                this.getLogger().debug("Identified duplicate type {} in {}; will re-process excluding it", (Object)typeName, (Object)path);
            }
            throw new GradleException(String.format("Failed to compile schema definition file %s", path), (Throwable)ex);
        }
        catch (NullPointerException ex) {
            fileState.setError(ex);
            processingState.queueForDelayedProcessing(fileState);
            this.getLogger().debug("Encountered null reference while parsing {} (possibly due to unresolved dependency); will try again", (Object)path);
        }
        catch (IOException ex) {
            throw new GradleException(String.format("Failed to compile schema definition file %s", path), (Throwable)ex);
        }
    }

    private void compile(Protocol protocol, File sourceFile) throws IOException {
        this.compile(new SpecificCompiler(protocol), sourceFile);
    }

    private void compile(Schema schema, File sourceFile) throws IOException {
        this.compile(new SpecificCompiler(schema), sourceFile);
    }

    private void compile(SpecificCompiler compiler, File sourceFile) throws IOException {
        String templateDirectory = this.getTemplateDirectory();
        compiler.setOutputCharacterEncoding(this.getOutputCharacterEncoding());
        compiler.setStringType(this.parsedStringType);
        compiler.setFieldVisibility(this.parsedFieldVisibility);
        if (templateDirectory != null) {
            compiler.setTemplateDir(templateDirectory);
        }
        compiler.setCreateSetters(this.isCreateSetters());
        compiler.compileToDestination(sourceFile, this.getOutputDir());
    }
}

