/*
 * Decompiled with CFR 0.152.
 */
package com.commercehub.gradle.plugin.avro;

import java.util.Set;
import java.util.TreeSet;
import org.apache.avro.Schema;
import org.gradle.api.GradleException;

class TypeState {
    private final String name;
    private final Set<String> locations = new TreeSet<String>();
    private Schema schema;

    TypeState(String name) {
        this.name = name;
    }

    void processTypeDefinition(String path, Schema schemaToProcess) {
        this.locations.add(path);
        if (this.schema == null) {
            this.schema = schemaToProcess;
        } else if (!this.schema.equals((Object)schemaToProcess)) {
            throw new GradleException(String.format("Found conflicting definition of type %s in %s", this.name, this.locations));
        }
    }

    String getName() {
        return this.name;
    }

    Schema getSchema() {
        return this.schema;
    }

    boolean hasLocation(String location) {
        return this.locations.contains(location);
    }
}

