/*
 * Decompiled with CFR 0.152.
 */
package com.commercehub.gradle.plugin.avro;

import com.commercehub.gradle.plugin.avro.AvroExtension;
import com.commercehub.gradle.plugin.avro.Constants;
import com.commercehub.gradle.plugin.avro.DefaultAvroExtension;
import com.commercehub.gradle.plugin.avro.GenerateAvroJavaTask;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;

public class AvroBasePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        AvroBasePlugin.configureExtension(project);
    }

    private static void configureExtension(Project project) {
        final AvroExtension avroExtension = (AvroExtension)project.getExtensions().create("avro", DefaultAvroExtension.class, new Object[0]);
        ConventionMapping extensionMapping = AvroBasePlugin.conventionMapping(avroExtension);
        extensionMapping.map("stringType", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Constants.DEFAULT_STRING_TYPE;
            }
        });
        extensionMapping.map("fieldVisibility", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Constants.DEFAULT_FIELD_VISIBILITY;
            }
        });
        extensionMapping.map("createSetters", (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return true;
            }
        });
        extensionMapping.map("enableDecimalLogicalType", (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return true;
            }
        });
        project.getTasks().withType(GenerateAvroJavaTask.class).all((Action)new Action<GenerateAvroJavaTask>(){

            public void execute(GenerateAvroJavaTask task) {
                ConventionMapping taskMapping = AvroBasePlugin.conventionMapping((Object)task);
                taskMapping.map("outputCharacterEncoding", (Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return avroExtension.getOutputCharacterEncoding();
                    }
                });
                taskMapping.map("stringType", (Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return avroExtension.getStringType();
                    }
                });
                taskMapping.map("fieldVisibility", (Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return avroExtension.getFieldVisibility();
                    }
                });
                taskMapping.map("templateDirectory", (Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return avroExtension.getTemplateDirectory();
                    }
                });
                taskMapping.map("createSetters", (Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return avroExtension.isCreateSetters();
                    }
                });
                taskMapping.map("enableDecimalLogicalType", (Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return avroExtension.isEnableDecimalLogicalType();
                    }
                });
            }
        });
    }

    private static ConventionMapping conventionMapping(Object conventionAware) {
        return ((IConventionAware)conventionAware).getConventionMapping();
    }
}

