/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.SqlConnection;
import com.coditory.sherlock.SqlQueries;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicBoolean;

class SqlTableInitializer {
    private final SqlQueries sqlQueries;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    SqlTableInitializer(SqlQueries sqlQueries) {
        this.sqlQueries = sqlQueries;
    }

    PreparedStatement getInitializedStatement(SqlConnection connection, String sql) {
        if (this.initialized.compareAndSet(false, true)) {
            this.initialize(connection);
        }
        try {
            return connection.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Could not create SQL statement", e);
        }
    }

    void initialize(SqlConnection connection) {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate(this.sqlQueries.createLocksTable());
            this.initialized.set(true);
        }
        catch (SQLException e) {
            try (PreparedStatement statement2 = connection.prepareStatement(this.sqlQueries.checkTableExits());){
                statement2.executeQuery();
                this.initialized.set(true);
            }
            catch (SQLException checkException) {
                throw new IllegalStateException("Could not initialize locks table", e);
            }
        }
    }
}

