/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.ConnectionPool;
import com.coditory.sherlock.DistributedLockConnector;
import com.coditory.sherlock.LockDuration;
import com.coditory.sherlock.LockId;
import com.coditory.sherlock.LockRequest;
import com.coditory.sherlock.OwnerId;
import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.SherlockException;
import com.coditory.sherlock.SqlConnection;
import com.coditory.sherlock.SqlQueries;
import com.coditory.sherlock.SqlTableInitializer;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Clock;
import java.time.Instant;

class SqlDistributedLockConnector
implements DistributedLockConnector {
    private final ConnectionPool connectionPool;
    private final SqlTableInitializer sqlTableInitializer;
    private final SqlQueries sqlQueries;
    private final Clock clock;

    SqlDistributedLockConnector(ConnectionPool connectionPool, String tableName, Clock clock) {
        this.clock = (Clock)Preconditions.expectNonNull((Object)clock, (String)"Expected non null clock");
        this.sqlQueries = new SqlQueries(tableName);
        this.connectionPool = connectionPool;
        this.sqlTableInitializer = new SqlTableInitializer(this.sqlQueries);
    }

    public void initialize() {
        try (SqlConnection connection = this.connectionPool.getConnection();){
            this.sqlTableInitializer.initialize(connection);
        }
        catch (Throwable e) {
            throw new SherlockException("Could not initialize SQL table", e);
        }
    }

    public boolean acquire(LockRequest lockRequest) {
        boolean bl;
        block8: {
            Instant now = this.now();
            SqlConnection connection = this.connectionPool.getConnection();
            try {
                boolean bl2 = bl = this.updateReleasedLock(connection, lockRequest, now) || this.insertLock(connection, lockRequest, now);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw new SherlockException("Could not acquire lock: " + lockRequest, e);
                }
            }
            connection.close();
        }
        return bl;
    }

    public boolean acquireOrProlong(LockRequest lockRequest) {
        boolean bl;
        block8: {
            Instant now = this.now();
            SqlConnection connection = this.connectionPool.getConnection();
            try {
                boolean bl2 = bl = this.updateAcquiredOrReleasedLock(connection, lockRequest, now) || this.insertLock(connection, lockRequest, now);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw new SherlockException("Could not acquire or prolong lock: " + lockRequest, e);
                }
            }
            connection.close();
        }
        return bl;
    }

    public boolean forceAcquire(LockRequest lockRequest) {
        boolean bl;
        block8: {
            Instant now = this.now();
            SqlConnection connection = this.connectionPool.getConnection();
            try {
                boolean bl2 = bl = this.updateLockById(connection, lockRequest, now) || this.insertLock(connection, lockRequest, now);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw new SherlockException("Could not force acquire lock: " + lockRequest, e);
                }
            }
            connection.close();
        }
        return bl;
    }

    private boolean updateReleasedLock(SqlConnection connection, LockRequest lockRequest, Instant now) throws SQLException {
        String lockId = lockRequest.getLockId().getValue();
        Instant expiresAt = this.expiresAt(now, lockRequest.getDuration());
        try (PreparedStatement statement = this.getStatement(connection, this.sqlQueries.updateReleasedLock());){
            statement.setString(1, lockRequest.getOwnerId().getValue());
            statement.setTimestamp(2, this.timestamp(now));
            this.setupOptionalTimestamp(statement, 3, expiresAt);
            statement.setString(4, lockId);
            statement.setTimestamp(5, this.timestamp(now));
            boolean bl = statement.executeUpdate() > 0;
            return bl;
        }
    }

    private boolean updateAcquiredOrReleasedLock(SqlConnection connection, LockRequest lockRequest, Instant now) throws SQLException {
        String lockId = lockRequest.getLockId().getValue();
        Instant expiresAt = this.expiresAt(now, lockRequest.getDuration());
        try (PreparedStatement statement = this.getStatement(connection, this.sqlQueries.updateAcquiredOrReleasedLock());){
            statement.setString(1, lockRequest.getOwnerId().getValue());
            statement.setTimestamp(2, this.timestamp(now));
            this.setupOptionalTimestamp(statement, 3, expiresAt);
            statement.setString(4, lockId);
            statement.setString(5, lockRequest.getOwnerId().getValue());
            statement.setTimestamp(6, this.timestamp(now));
            boolean bl = statement.executeUpdate() > 0;
            return bl;
        }
    }

    private boolean updateLockById(SqlConnection connection, LockRequest lockRequest, Instant now) throws SQLException {
        String lockId = lockRequest.getLockId().getValue();
        Instant expiresAt = this.expiresAt(now, lockRequest.getDuration());
        try (PreparedStatement statement = this.getStatement(connection, this.sqlQueries.updateLockById());){
            statement.setString(1, lockRequest.getOwnerId().getValue());
            statement.setTimestamp(2, this.timestamp(now));
            this.setupOptionalTimestamp(statement, 3, expiresAt);
            statement.setString(4, lockId);
            boolean bl = statement.executeUpdate() > 0;
            return bl;
        }
    }

    private boolean insertLock(SqlConnection connection, LockRequest lockRequest, Instant now) throws SQLException {
        boolean bl;
        block9: {
            String lockId = lockRequest.getLockId().getValue();
            Instant expiresAt = this.expiresAt(now, lockRequest.getDuration());
            PreparedStatement statement = this.getStatement(connection, this.sqlQueries.insertLock());
            try {
                statement.setString(1, lockId);
                statement.setString(2, lockRequest.getOwnerId().getValue());
                statement.setTimestamp(3, this.timestamp(now));
                this.setupOptionalTimestamp(statement, 4, expiresAt);
                boolean bl2 = bl = statement.executeUpdate() > 0;
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    if (!e.getMessage().toLowerCase().contains("duplicate")) {
                        throw e;
                    }
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean release(LockId lockId, OwnerId ownerId) {
        try (SqlConnection connection = this.connectionPool.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement statement = this.getStatement(connection, this.sqlQueries.deleteAcquiredByIdAndOwnerId());
                try {
                    statement.setString(1, lockId.getValue());
                    statement.setString(2, ownerId.getValue());
                    statement.setTimestamp(3, this.timestamp(this.now()));
                    boolean bl2 = bl = statement.executeUpdate() > 0;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (Throwable e) {
            throw new SherlockException("Could not release lock: " + lockId.getValue() + ", owner: " + ownerId, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean forceRelease(LockId lockId) {
        try (SqlConnection connection = this.connectionPool.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement statement = this.getStatement(connection, this.sqlQueries.deleteAcquiredById());
                try {
                    statement.setString(1, lockId.getValue());
                    statement.setTimestamp(2, this.timestamp(this.now()));
                    boolean bl2 = bl = statement.executeUpdate() > 0;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (Throwable e) {
            throw new SherlockException("Could not force release lock: " + lockId.getValue(), e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean forceReleaseAll() {
        try (SqlConnection connection = this.connectionPool.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement statement = this.getStatement(connection, this.sqlQueries.deleteAll());
                try {
                    boolean bl2 = bl = statement.executeUpdate() > 0;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (Throwable e) {
            throw new IllegalStateException("Could not force release all locks", e);
        }
    }

    private Instant now() {
        return this.clock.instant();
    }

    private Instant expiresAt(Instant now, LockDuration duration) {
        if (duration == null || duration.getValue() == null) {
            return null;
        }
        return now.plus(duration.getValue());
    }

    private void setupOptionalTimestamp(PreparedStatement statement, int index, Instant instant) throws SQLException {
        if (instant != null) {
            statement.setTimestamp(index, this.timestamp(instant));
        } else {
            statement.setNull(index, 93);
        }
    }

    private Timestamp timestamp(Instant instant) {
        return new Timestamp(instant.toEpochMilli());
    }

    private PreparedStatement getStatement(SqlConnection connection, String sql) {
        return this.sqlTableInitializer.getInitializedStatement(connection, sql);
    }
}

