/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.DistributedLockConnector;
import com.coditory.sherlock.LockDuration;
import com.coditory.sherlock.LockId;
import com.coditory.sherlock.LockRequest;
import com.coditory.sherlock.OwnerId;
import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.SqlQueries;
import com.coditory.sherlock.SqlTableInitializer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Clock;
import java.time.Instant;

class SqlDistributedLockConnector
implements DistributedLockConnector {
    private final SqlTableInitializer sqlTableInitializer;
    private final SqlQueries sqlQueries;
    private final Clock clock;

    SqlDistributedLockConnector(Connection connection, String tableName, Clock clock) {
        this.clock = (Clock)Preconditions.expectNonNull((Object)clock, (String)"Expected non null clock");
        this.sqlQueries = new SqlQueries(tableName);
        this.sqlTableInitializer = new SqlTableInitializer(this.sqlQueries, connection);
    }

    public void initialize() {
        this.sqlTableInitializer.initialize();
    }

    public boolean acquire(LockRequest lockRequest) {
        Instant now = this.now();
        return this.updateReleasedLock(lockRequest, now) || this.insertLock(lockRequest, now);
    }

    public boolean acquireOrProlong(LockRequest lockRequest) {
        Instant now = this.now();
        return this.updateAcquiredOrReleasedLock(lockRequest, now) || this.insertLock(lockRequest, now);
    }

    public boolean forceAcquire(LockRequest lockRequest) {
        Instant now = this.now();
        return this.updateLockById(lockRequest, now) || this.insertLock(lockRequest, now);
    }

    private boolean updateReleasedLock(LockRequest lockRequest, Instant now) {
        boolean bl;
        block8: {
            String lockId = lockRequest.getLockId().getValue();
            Instant expiresAt = this.expiresAt(now, lockRequest.getDuration());
            PreparedStatement statement = this.getStatement(this.sqlQueries.updateReleasedLock());
            try {
                statement.setString(1, lockRequest.getOwnerId().getValue());
                statement.setTimestamp(2, this.timestamp(now));
                this.setupOptionalTimestamp(statement, 3, expiresAt);
                statement.setString(4, lockId);
                statement.setTimestamp(5, this.timestamp(now));
                boolean bl2 = bl = statement.executeUpdate() > 0;
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IllegalStateException("SQL Error when updating a lock: " + lockId, e);
                }
            }
            statement.close();
        }
        return bl;
    }

    private boolean updateAcquiredOrReleasedLock(LockRequest lockRequest, Instant now) {
        boolean bl;
        block8: {
            String lockId = lockRequest.getLockId().getValue();
            Instant expiresAt = this.expiresAt(now, lockRequest.getDuration());
            PreparedStatement statement = this.getStatement(this.sqlQueries.updateAcquiredOrReleasedLock());
            try {
                statement.setString(1, lockRequest.getOwnerId().getValue());
                statement.setTimestamp(2, this.timestamp(now));
                this.setupOptionalTimestamp(statement, 3, expiresAt);
                statement.setString(4, lockId);
                statement.setString(5, lockRequest.getOwnerId().getValue());
                statement.setTimestamp(6, this.timestamp(now));
                boolean bl2 = bl = statement.executeUpdate() > 0;
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IllegalStateException("SQL Error when updating a lock: " + lockId, e);
                }
            }
            statement.close();
        }
        return bl;
    }

    private boolean updateLockById(LockRequest lockRequest, Instant now) {
        boolean bl;
        block8: {
            String lockId = lockRequest.getLockId().getValue();
            Instant expiresAt = this.expiresAt(now, lockRequest.getDuration());
            PreparedStatement statement = this.getStatement(this.sqlQueries.updateLockById());
            try {
                statement.setString(1, lockRequest.getOwnerId().getValue());
                statement.setTimestamp(2, this.timestamp(now));
                this.setupOptionalTimestamp(statement, 3, expiresAt);
                statement.setString(4, lockId);
                boolean bl2 = bl = statement.executeUpdate() > 0;
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IllegalStateException("SQL Error when updating a lock: " + lockId, e);
                }
            }
            statement.close();
        }
        return bl;
    }

    private boolean insertLock(LockRequest lockRequest, Instant now) {
        boolean bl;
        block9: {
            String lockId = lockRequest.getLockId().getValue();
            Instant expiresAt = this.expiresAt(now, lockRequest.getDuration());
            PreparedStatement statement = this.getStatement(this.sqlQueries.insertLock());
            try {
                statement.setString(1, lockId);
                statement.setString(2, lockRequest.getOwnerId().getValue());
                statement.setTimestamp(3, this.timestamp(now));
                this.setupOptionalTimestamp(statement, 4, expiresAt);
                boolean bl2 = bl = statement.executeUpdate() > 0;
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    if (!e.getMessage().toLowerCase().contains("duplicate")) {
                        throw new IllegalStateException("SQL Error when inserting a lock: " + lockId, e);
                    }
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }

    public boolean release(LockId lockId, OwnerId ownerId) {
        boolean bl;
        block8: {
            PreparedStatement statement = this.getStatement(this.sqlQueries.deleteAcquiredByIdAndOwnerId());
            try {
                statement.setString(1, lockId.getValue());
                statement.setString(2, ownerId.getValue());
                statement.setTimestamp(3, this.timestamp(this.now()));
                boolean bl2 = bl = statement.executeUpdate() > 0;
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IllegalStateException("Could not delete lock: " + lockId.getValue(), e);
                }
            }
            statement.close();
        }
        return bl;
    }

    public boolean forceRelease(LockId lockId) {
        boolean bl;
        block8: {
            PreparedStatement statement = this.getStatement(this.sqlQueries.deleteAcquiredById());
            try {
                statement.setString(1, lockId.getValue());
                statement.setTimestamp(2, this.timestamp(this.now()));
                boolean bl2 = bl = statement.executeUpdate() > 0;
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IllegalStateException("Could not delete lock: " + lockId.getValue(), e);
                }
            }
            statement.close();
        }
        return bl;
    }

    public boolean forceReleaseAll() {
        boolean bl;
        block8: {
            PreparedStatement statement = this.getStatement(this.sqlQueries.deleteAll());
            try {
                boolean bl2 = bl = statement.executeUpdate() > 0;
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IllegalStateException("Could not delete all locks", e);
                }
            }
            statement.close();
        }
        return bl;
    }

    private Instant now() {
        return this.clock.instant();
    }

    private Instant expiresAt(Instant now, LockDuration duration) {
        if (duration == null || duration.getValue() == null) {
            return null;
        }
        return now.plus(duration.getValue());
    }

    private void setupOptionalTimestamp(PreparedStatement statement, int index, Instant instant) throws SQLException {
        if (instant != null) {
            statement.setTimestamp(index, this.timestamp(instant));
        } else {
            statement.setNull(index, 93);
        }
    }

    private Timestamp timestamp(Instant instant) {
        return new Timestamp(instant.toEpochMilli());
    }

    private PreparedStatement getStatement(String sql) {
        return this.sqlTableInitializer.getInitializedStatement(sql);
    }
}

