/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.DistributedLockConnector;
import com.coditory.sherlock.Sherlock;
import com.coditory.sherlock.SherlockDefaults;
import com.coditory.sherlock.SherlockWithConnectorBuilder;
import com.coditory.sherlock.SqlDistributedLockConnector;
import com.coditory.sherlock.util.Preconditions;
import java.sql.Connection;
import java.time.Clock;

public final class SqlSherlock
extends SherlockWithConnectorBuilder<SqlSherlock> {
    private String tableName = "locks";
    private Clock clock = SherlockDefaults.DEFAULT_CLOCK;
    private Connection connection;

    public static SqlSherlock builder() {
        return new SqlSherlock();
    }

    private SqlSherlock() {
    }

    public SqlSherlock withConnection(Connection connection) {
        this.connection = (Connection)Preconditions.expectNonNull((Object)connection, (String)"Expected non null connection");
        return this;
    }

    public SqlSherlock withLocksTable(String tableName) {
        this.tableName = Preconditions.expectNonEmpty((String)tableName, (String)"Expected non empty tableName");
        return this;
    }

    public SqlSherlock withClock(Clock clock) {
        this.clock = (Clock)Preconditions.expectNonNull((Object)clock, (String)"Expected non null clock");
        return this;
    }

    public Sherlock build() {
        Preconditions.expectNonNull((Object)this.connection, (String)"Expected non null connection");
        SqlDistributedLockConnector connector = new SqlDistributedLockConnector(this.connection, this.tableName, this.clock);
        return super.build((DistributedLockConnector)connector);
    }
}

