/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.Preconditions;
import com.coditory.sherlock.UuidGenerator;
import java.util.Objects;

final class OwnerId {
    private final String id;

    static OwnerId uniqueOwnerId() {
        return new OwnerId(UuidGenerator.uuid());
    }

    static OwnerId of(String value) {
        return new OwnerId(value);
    }

    private OwnerId(String id) {
        this.id = Preconditions.expectNonEmpty(id, "Expected non empty instance id");
    }

    String getValue() {
        return this.id;
    }

    public String toString() {
        return "OwnerId(" + this.id + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OwnerId ownerId = (OwnerId)o;
        return Objects.equals(this.id, ownerId.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

