/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.DistributedLock;
import com.coditory.sherlock.DistributedLockBuilder;
import com.coditory.sherlock.DistributedLockMock;
import com.coditory.sherlock.LockDuration;
import com.coditory.sherlock.LockId;
import com.coditory.sherlock.OwnerId;
import com.coditory.sherlock.Sherlock;
import java.util.HashMap;
import java.util.Map;

public final class SherlockStub
implements Sherlock {
    private final Map<String, DistributedLock> locksById = new HashMap<String, DistributedLock>();
    private boolean defaultLockResult = true;

    public static SherlockStub withReleasedLocks() {
        return new SherlockStub().withDefaultAcquireResult(true);
    }

    public static SherlockStub withAcquiredLocks() {
        return new SherlockStub().withDefaultAcquireResult(false);
    }

    public SherlockStub withLock(DistributedLock lock) {
        this.locksById.put(lock.getId(), lock);
        return this;
    }

    private SherlockStub withDefaultAcquireResult(boolean result) {
        this.defaultLockResult = result;
        return this;
    }

    @Override
    public void initialize() {
    }

    @Override
    public DistributedLockBuilder<DistributedLock> createLock() {
        return this.getLockOrDefault();
    }

    @Override
    public DistributedLockBuilder<DistributedLock> createReentrantLock() {
        return this.getLockOrDefault();
    }

    @Override
    public DistributedLockBuilder<DistributedLock> createOverridingLock() {
        return this.getLockOrDefault();
    }

    @Override
    public boolean forceReleaseAllLocks() {
        return false;
    }

    private DistributedLockBuilder<DistributedLock> getLockOrDefault() {
        return new DistributedLockBuilder(this::getLockOrDefault);
    }

    private DistributedLock getLockOrDefault(LockId id, LockDuration duration, OwnerId ownerId) {
        DistributedLockMock defaultLock = DistributedLockMock.lockStub(id.getValue(), this.defaultLockResult);
        return this.locksById.getOrDefault(id.getValue(), defaultLock);
    }
}

