/*
 * Decompiled with CFR 0.152.
 */
package com.coditory.sherlock;

import com.coditory.sherlock.DistributedLock;
import com.coditory.sherlock.LockId;
import com.coditory.sherlock.util.Preconditions;
import com.coditory.sherlock.util.UuidGenerator;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public final class DistributedLockMock
implements DistributedLock {
    private final DistributedLock lock;
    private final AtomicInteger releases = new AtomicInteger(0);
    private final AtomicInteger acquisitions = new AtomicInteger(0);
    private final AtomicInteger successfulReleases = new AtomicInteger(0);
    private final AtomicInteger successfulAcquisitions = new AtomicInteger(0);

    public static DistributedLockMock releasedInMemoryLock() {
        return DistributedLockMock.releasedInMemoryLock(UuidGenerator.uuid());
    }

    public static DistributedLockMock acquiredInMemoryLock() {
        return DistributedLockMock.acquiredInMemoryLock(UuidGenerator.uuid());
    }

    public static DistributedLockMock releasedInMemoryLock(String lockId) {
        return DistributedLockMock.inMemoryLock(lockId, false);
    }

    public static DistributedLockMock acquiredInMemoryLock(String lockId) {
        return DistributedLockMock.inMemoryLock(lockId, true);
    }

    private static DistributedLockMock inMemoryLock(String lockId, boolean state) {
        return DistributedLockMock.of(InMemoryDistributedLockStub.inMemoryLock(LockId.of((String)lockId), state));
    }

    public static DistributedLockMock releasedReentrantInMemoryLock() {
        return DistributedLockMock.releasedReentrantInMemoryLock(UuidGenerator.uuid());
    }

    public static DistributedLockMock acquiredReentrantInMemoryLock() {
        return DistributedLockMock.acquiredReentrantInMemoryLock(UuidGenerator.uuid());
    }

    public static DistributedLockMock releasedReentrantInMemoryLock(String lockId) {
        return DistributedLockMock.reentrantInMemoryLock(lockId, false);
    }

    public static DistributedLockMock acquiredReentrantInMemoryLock(String lockId) {
        return DistributedLockMock.reentrantInMemoryLock(lockId, true);
    }

    private static DistributedLockMock reentrantInMemoryLock(String lockId, boolean state) {
        return DistributedLockMock.of(InMemoryDistributedLockStub.reentrantInMemoryLock(LockId.of((String)lockId), state));
    }

    public static DistributedLockMock lockStub(boolean result) {
        return DistributedLockMock.lockStub(UuidGenerator.uuid(), result, result);
    }

    public static DistributedLockMock lockStub(boolean acquireResult, boolean releaseResult) {
        return DistributedLockMock.lockStub(UuidGenerator.uuid(), acquireResult, releaseResult);
    }

    public static DistributedLockMock lockStub(String lockId, boolean result) {
        return DistributedLockMock.of(DistributedLockMock.lockStub(lockId, result, result));
    }

    public static DistributedLockMock lockStub(String lockId, boolean acquireResult, boolean releaseResult) {
        SequencedDistributedLockStub lock = new SequencedDistributedLockStub(lockId, List.of(Boolean.valueOf(acquireResult)), List.of(Boolean.valueOf(releaseResult)));
        return DistributedLockMock.of(lock);
    }

    public static DistributedLockMock sequencedLock(List<Boolean> acquireResults, List<Boolean> releaseResults) {
        return DistributedLockMock.sequencedLock(UuidGenerator.uuid(), acquireResults, releaseResults);
    }

    public static DistributedLockMock sequencedLock(String lockId, List<Boolean> acquireResults, List<Boolean> releaseResults) {
        return DistributedLockMock.of(new SequencedDistributedLockStub(lockId, acquireResults, releaseResults));
    }

    private static DistributedLockMock of(DistributedLock lock) {
        return new DistributedLockMock(lock);
    }

    private DistributedLockMock(DistributedLock lock) {
        this.lock = lock;
    }

    @Override
    public String getId() {
        return this.lock.getId();
    }

    @Override
    public boolean acquire() {
        return this.acquire(this.lock::acquire);
    }

    @Override
    public boolean acquire(Duration duration) {
        return this.acquire(() -> this.lock.acquire(duration));
    }

    @Override
    public boolean acquireForever() {
        return this.acquire(this.lock::acquireForever);
    }

    private boolean acquire(Supplier<Boolean> acquireAction) {
        this.acquisitions.incrementAndGet();
        boolean result = acquireAction.get();
        if (result) {
            this.successfulAcquisitions.incrementAndGet();
        }
        return result;
    }

    @Override
    public boolean release() {
        this.releases.incrementAndGet();
        boolean result = this.lock.release();
        if (result) {
            this.successfulReleases.incrementAndGet();
        }
        return result;
    }

    public int successfulReleases() {
        return this.successfulReleases.get();
    }

    public int successfulAcquisitions() {
        return this.successfulAcquisitions.get();
    }

    public int releases() {
        return this.releases.get();
    }

    public int acquisitions() {
        return this.acquisitions.get();
    }

    public int rejectedReleases() {
        return this.releases() - this.successfulReleases();
    }

    public int rejectedAcquisitions() {
        return this.acquisitions() - this.successfulAcquisitions();
    }

    public boolean wasAcquired() {
        return this.successfulAcquisitions() > 0;
    }

    public boolean wasReleased() {
        return this.successfulReleases() > 0;
    }

    public boolean wasAcquiredAndReleased() {
        return this.wasAcquired() && this.wasReleased();
    }

    public boolean wasAcquireRejected() {
        return this.successfulAcquisitions() < this.acquisitions();
    }

    public boolean wasReleaseRejected() {
        return this.successfulReleases() < this.releases();
    }

    public boolean wasAcquireInvoked() {
        return this.acquisitions() > 0;
    }

    public boolean wasReleaseInvoked() {
        return this.releases() > 0;
    }

    static class SequencedDistributedLockStub
    implements DistributedLock {
        private final LockId lockId;
        private final ConcurrentLinkedQueue<Boolean> acquireResults;
        private final ConcurrentLinkedQueue<Boolean> releaseResults;
        private final boolean defaultAcquireResult;
        private final boolean defaultReleaseResult;

        private SequencedDistributedLockStub(String lockId, List<Boolean> acquireResults, List<Boolean> releaseResults) {
            this(LockId.of((String)lockId), acquireResults, releaseResults);
        }

        private SequencedDistributedLockStub(LockId lockId, List<Boolean> acquireResults, List<Boolean> releaseResults) {
            Preconditions.expectNonEmpty(acquireResults, (String)"Expected non empty acquire results");
            Preconditions.expectNonEmpty(releaseResults, (String)"Expected non empty release results");
            this.lockId = (LockId)Preconditions.expectNonNull((Object)lockId, (String)"Expected non null lockId");
            this.acquireResults = new ConcurrentLinkedQueue<Boolean>(acquireResults);
            this.releaseResults = new ConcurrentLinkedQueue<Boolean>(releaseResults);
            this.defaultAcquireResult = acquireResults.get(acquireResults.size() - 1);
            this.defaultReleaseResult = releaseResults.get(releaseResults.size() - 1);
        }

        @Override
        public String getId() {
            return this.lockId.getValue();
        }

        @Override
        public boolean acquire() {
            return this.pollOrDefault(this.acquireResults, this.defaultAcquireResult);
        }

        @Override
        public boolean acquire(Duration duration) {
            return this.acquire();
        }

        @Override
        public boolean acquireForever() {
            return this.acquire();
        }

        @Override
        public boolean release() {
            return this.pollOrDefault(this.releaseResults, this.defaultReleaseResult);
        }

        private boolean pollOrDefault(ConcurrentLinkedQueue<Boolean> queue, boolean defaultValue) {
            Boolean value = queue.poll();
            return value != null ? value : defaultValue;
        }
    }

    private static class InMemoryDistributedLockStub
    implements DistributedLock {
        private final LockId lockId;
        private final boolean reentrant;
        private AtomicBoolean acquired;

        static InMemoryDistributedLockStub reentrantInMemoryLock(LockId lockId, boolean acquired) {
            return new InMemoryDistributedLockStub(lockId, true, acquired);
        }

        static InMemoryDistributedLockStub inMemoryLock(LockId lockId, boolean acquired) {
            return new InMemoryDistributedLockStub(lockId, false, acquired);
        }

        private InMemoryDistributedLockStub(LockId lockId, boolean reentrant, boolean acquired) {
            this.lockId = (LockId)Preconditions.expectNonNull((Object)lockId, (String)"Expected non null lockId");
            this.reentrant = reentrant;
            this.acquired = new AtomicBoolean(acquired);
        }

        @Override
        public String getId() {
            return this.lockId.getValue();
        }

        @Override
        public boolean acquire() {
            if (this.reentrant) {
                this.acquired.set(true);
                return true;
            }
            return this.acquired.compareAndSet(false, true);
        }

        @Override
        public boolean acquire(Duration duration) {
            return this.acquire();
        }

        @Override
        public boolean acquireForever() {
            return this.acquire();
        }

        @Override
        public boolean release() {
            return this.acquired.compareAndSet(true, false);
        }
    }
}

