/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.core.transaction.txc.analy.undo;

import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.FieldCluster;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.FieldValue;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.StatementInfo;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.undo.TableRecord;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.util.SqlUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class UndoLogAnalyser {
    public static StatementInfo update(TableRecord tableRecord) {
        String k = tableRecord.getTableName();
        FieldCluster v = tableRecord.getFieldCluster();
        Object[] params = new Object[v.getFields().size() + v.getPrimaryKeys().size()];
        StringBuilder rollbackSql = new StringBuilder().append("UPDATE ").append(k).append(" SET ");
        int index = 0;
        int i = 0;
        while (i < v.getFields().size()) {
            FieldValue fieldValue = v.getFields().get(i);
            rollbackSql.append(fieldValue.getFieldName()).append("=?").append(", ");
            params[index] = fieldValue.getValue();
            ++i;
            ++index;
        }
        SqlUtils.cutSuffix(", ", rollbackSql);
        rollbackSql.append(" WHERE ");
        int j = UndoLogAnalyser.whereBuilder(v.getPrimaryKeys(), rollbackSql, params, index - 1);
        SqlUtils.cutSuffix(" and ", rollbackSql);
        return new StatementInfo(rollbackSql.toString(), Arrays.copyOf(params, j));
    }

    public static StatementInfo delete(TableRecord tableRecord) {
        String k = tableRecord.getTableName();
        FieldCluster v = tableRecord.getFieldCluster();
        StringBuilder rollbackSql = new StringBuilder("INSERT INTO ").append(k).append('(');
        StringBuilder values = new StringBuilder();
        Object[] params = new Object[v.getFields().size()];
        int j = 0;
        int i = 0;
        while (i < v.getFields().size()) {
            FieldValue fieldValue = v.getFields().get(i);
            if (Objects.isNull(fieldValue.getValue())) {
                --j;
            } else {
                params[i] = fieldValue.getValue();
                rollbackSql.append(fieldValue.getFieldName()).append(", ");
                values.append("?, ");
            }
            ++i;
            ++j;
        }
        SqlUtils.cutSuffix(", ", rollbackSql);
        SqlUtils.cutSuffix(", ", values);
        rollbackSql.append(") values(").append((CharSequence)values).append(')');
        return new StatementInfo(rollbackSql.toString(), Arrays.copyOf(params, j + 1));
    }

    public static StatementInfo insert(TableRecord tableRecord) {
        StringBuilder rollbackSql = new StringBuilder("DELETE ").append(" FROM ").append(tableRecord.getTableName()).append(" WHERE ");
        Object[] paramArray = new Object[tableRecord.getFieldCluster().getPrimaryKeys().size()];
        int j = UndoLogAnalyser.whereBuilder(tableRecord.getFieldCluster().getPrimaryKeys(), rollbackSql, paramArray, -1);
        SqlUtils.cutSuffix(" and ", rollbackSql);
        return new StatementInfo(rollbackSql.toString(), Arrays.copyOf(paramArray, j));
    }

    private static int whereBuilder(List<FieldValue> primaryKeys, StringBuilder sqlBuilder, Object[] params, int index) {
        int j = index;
        for (FieldValue fieldValue : primaryKeys) {
            ++j;
            if (Objects.isNull(fieldValue.getValue())) {
                --j;
                continue;
            }
            sqlBuilder.append(fieldValue.getFieldName()).append("=?").append(" and ");
            params[j] = fieldValue.getValue();
        }
        return j + 1;
    }
}

