/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.core.template;

import com.codingapi.txlcn.common.exception.TransactionClearException;
import com.codingapi.txlcn.logger.TxLogger;
import com.codingapi.txlcn.tc.core.checking.DTXChecking;
import com.codingapi.txlcn.tc.core.context.TCGlobalContext;
import com.codingapi.txlcn.tc.corelog.aspect.AspectLogger;
import com.codingapi.txlcn.tc.support.TxLcnBeanHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransactionCleanTemplate {
    private final TxLcnBeanHelper transactionBeanHelper;
    private final DTXChecking dtxChecking;
    private final AspectLogger aspectLogger;
    private static final TxLogger txLogger = TxLogger.newLogger(TransactionCleanTemplate.class);
    private final TCGlobalContext globalContext;

    @Autowired
    public TransactionCleanTemplate(TxLcnBeanHelper transactionBeanHelper, DTXChecking dtxChecking, AspectLogger aspectLogger, TCGlobalContext globalContext) {
        this.transactionBeanHelper = transactionBeanHelper;
        this.dtxChecking = dtxChecking;
        this.aspectLogger = aspectLogger;
        this.globalContext = globalContext;
    }

    public void clean(String groupId, String unitId, String unitType, int state) throws TransactionClearException {
        txLogger.txTrace(groupId, unitId, "clean transaction", new Object[0]);
        try {
            this.cleanWithoutAspectLog(groupId, unitId, unitType, state);
            this.aspectLogger.clearLog(groupId, unitId);
        }
        catch (TransactionClearException e) {
            if (!e.isNeedCompensation()) {
                this.aspectLogger.clearLog(groupId, unitId);
            }
        }
        catch (Throwable throwable) {
            this.aspectLogger.clearLog(groupId, unitId);
        }
        txLogger.txTrace(groupId, unitId, "clean transaction over", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanWithoutAspectLog(String groupId, String unitId, String unitType, int state) throws TransactionClearException {
        try {
            this.transactionBeanHelper.loadTransactionCleanService(unitType).clear(groupId, state, unitId, unitType);
        }
        finally {
            this.globalContext.clearGroup(groupId);
            this.dtxChecking.stopDelayChecking(groupId, unitId);
        }
    }
}

