/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.logger.helper;

import com.codingapi.txlcn.common.util.Maps;
import com.codingapi.txlcn.common.util.Strings;
import com.codingapi.txlcn.logger.db.LogDbHelper;
import com.codingapi.txlcn.logger.db.LogDbProperties;
import com.codingapi.txlcn.logger.db.TxLog;
import com.codingapi.txlcn.logger.exception.NotEnableLogException;
import com.codingapi.txlcn.logger.exception.TxLoggerException;
import com.codingapi.txlcn.logger.helper.TxLcnLogDbHelper;
import com.codingapi.txlcn.logger.model.Field;
import com.codingapi.txlcn.logger.model.GroupId;
import com.codingapi.txlcn.logger.model.LogList;
import com.codingapi.txlcn.logger.model.StartTime;
import com.codingapi.txlcn.logger.model.StopTime;
import com.codingapi.txlcn.logger.model.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.GenerousBeanProcessor;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.springframework.beans.factory.annotation.Autowired;

public class MysqlLoggerHelper
implements TxLcnLogDbHelper {
    @Autowired(required=false)
    private LogDbHelper dbHelper;
    @Autowired
    private LogDbProperties logDbProperties;
    private RowProcessor processor = new BasicRowProcessor((BeanProcessor)new GenerousBeanProcessor());

    public void init() {
        if (this.logDbProperties.isEnabled()) {
            String sql = "CREATE TABLE IF NOT EXISTS `t_logger`  (\n  `id` bigint(20) NOT NULL AUTO_INCREMENT,\n  `group_id` varchar(64)  NOT NULL ,\n  `unit_id` varchar(32)  NOT NULL ,\n  `tag` varchar(50)  NOT NULL ,\n  `content` varchar(1024)  NOT NULL ,\n  `create_time` varchar(30) NOT NULL,\n  `app_name` varchar(128) NOT NULL,\n  PRIMARY KEY (`id`) USING BTREE\n) ";
            this.dbHelper.update(sql, new Object[0]);
        }
    }

    @Override
    public int insert(TxLog txLoggerInfo) {
        if (this.logDbProperties.isEnabled()) {
            String sql = "insert into t_logger(group_id,unit_id,tag,content,create_time,app_name) values(?,?,?,?,?,?)";
            return this.dbHelper.update(sql, txLoggerInfo.getGroupId(), txLoggerInfo.getUnitId(), txLoggerInfo.getTag(), Strings.format((String)txLoggerInfo.getContent(), (Map)Maps.of((Object)"xid", (Object)txLoggerInfo.getGroupId(), (Object)"uid", (Object)txLoggerInfo.getUnitId()), (Object[])txLoggerInfo.getArgs()), txLoggerInfo.getCreateTime(), txLoggerInfo.getAppName());
        }
        throw new NotEnableLogException("not enable logger");
    }

    private long total(String where, Object ... params) {
        if (this.logDbProperties.isEnabled()) {
            return (Long)this.dbHelper.query("select count(*) from t_logger where " + where, new ScalarHandler(), params);
        }
        throw new NotEnableLogException("not enable logger");
    }

    private String timeOrderSql(int timeOrder) {
        return "order by create_time " + (timeOrder == 1 ? "asc" : "desc");
    }

    @Override
    public void deleteByFields(List<Field> fields) throws TxLoggerException {
        if (Objects.isNull(this.dbHelper)) {
            throw new TxLoggerException("\u7cfb\u7edf\u65e5\u5fd7\u88ab\u7981\u7528");
        }
        StringBuilder sql = new StringBuilder("delete from t_logger where 1=1 and ");
        List<String> values = this.whereSqlAppender(sql, fields);
        this.dbHelper.update(sql.toString(), values.toArray(new Object[0]));
    }

    private List<String> whereSqlAppender(StringBuilder sql, List<Field> fields) {
        ArrayList<String> values = new ArrayList<String>(fields.size());
        fields.forEach(field -> {
            if (field instanceof GroupId) {
                sql.append("group_id=? and ");
                values.add(((GroupId)field).getGroupId());
            } else if (field instanceof Tag) {
                sql.append("tag=? and ");
                values.add(((Tag)field).getTag());
            } else if (field instanceof StartTime) {
                sql.append("create_time > ? and ");
                values.add(((StartTime)field).getStartTime());
            } else if (field instanceof StopTime) {
                sql.append("create_time < ? and ");
                values.add(((StopTime)field).getStopTime());
            }
        });
        sql.delete(sql.length() - 4, sql.length());
        return values;
    }

    @Override
    public LogList findByLimitAndFields(int page, int limit, int timeOrder, List<Field> list) throws TxLoggerException {
        if (Objects.isNull(this.dbHelper)) {
            throw new TxLoggerException("\u7cfb\u7edf\u65e5\u5fd7\u88ab\u7981\u7528");
        }
        StringBuilder countSql = new StringBuilder("select count(*) from t_logger where 1=1 and ");
        StringBuilder sql = new StringBuilder("select * from t_logger where 1=1 and ");
        List<String> values = this.whereSqlAppender(sql, list);
        this.whereSqlAppender(countSql, list);
        Object[] params = values.toArray(new Object[0]);
        long total = (Long)this.dbHelper.query(countSql.toString(), new ScalarHandler(), params);
        if (total < (long)((page - 1) * limit)) {
            page = 1;
        }
        sql.append(this.timeOrderSql(timeOrder)).append(" limit ").append((page - 1) * limit).append(", ").append(limit);
        List txLogs = (List)this.dbHelper.query(sql.toString(), new BeanListHandler(TxLog.class, this.processor), params);
        LogList logList = new LogList();
        logList.setTotal(total);
        logList.setTxLogs(txLogs);
        return logList;
    }
}

