/*
 * Decompiled with CFR 0.152.
 */
package com.codewaves.youtubethumbnailview.downloader;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.codewaves.youtubethumbnailview.Utils;
import com.codewaves.youtubethumbnailview.VideoInfo;
import com.codewaves.youtubethumbnailview.downloader.VideoInfoDownloader;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class ApiVideoInfoDownloader
implements VideoInfoDownloader {
    private String apiKey;
    private OkHttpClient client;

    public ApiVideoInfoDownloader(@Nullable String apiKey) {
        this.apiKey = apiKey;
        this.client = new OkHttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public VideoInfo download(@NonNull String url, int minThumbnailWidth) throws IOException {
        String id = Utils.getVideoIdFromUrl(url);
        String apiUrl = "https://www.googleapis.com/youtube/v3/videos?part=contentDetails,snippet&fields=items(snippet(title,thumbnails)),items(contentDetails(duration))&key=" + this.apiKey + "&id=" + id;
        Request request = new Request.Builder().url(apiUrl).build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            JsonElement root = new JsonParser().parse(response.body().charStream());
            JsonArray items = root.getAsJsonObject().get("items").getAsJsonArray();
            if (items.size() <= 0) {
                throw new IOException("Cannot find video");
            }
            JsonObject snippet = items.get(0).getAsJsonObject().get("snippet").getAsJsonObject();
            String title = snippet.get("title").getAsString();
            String thumbnail = this.findThumbnailUrl(snippet, minThumbnailWidth);
            JsonObject contentDetails = items.get(0).getAsJsonObject().get("contentDetails").getAsJsonObject();
            String duration = contentDetails.get("duration").getAsString();
            int seconds = Utils.durationToSeconds(duration);
            VideoInfo videoInfo = new VideoInfo(title, thumbnail, seconds);
            return videoInfo;
        }
    }

    private String findThumbnailUrl(@NonNull JsonObject snippet, int minWidth) {
        String thumbnailUrl = null;
        int thumbnailWidth = Integer.MAX_VALUE;
        try {
            JsonObject thumbnails = snippet.get("thumbnails").getAsJsonObject();
            for (Map.Entry entry : thumbnails.entrySet()) {
                JsonObject thumbnail = ((JsonElement)entry.getValue()).getAsJsonObject();
                int width = thumbnail.get("width").getAsInt();
                if (!(thumbnailUrl == null || width >= minWidth && thumbnailWidth < minWidth || width >= minWidth && width < thumbnailWidth) && (width >= minWidth || width <= thumbnailWidth)) continue;
                thumbnailUrl = thumbnail.get("url").getAsString();
                thumbnailWidth = width;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return thumbnailUrl;
    }
}

