/*
 * Decompiled with CFR 0.152.
 */
package com.codewaves.youtubethumbnailview;

import android.graphics.Bitmap;
import android.os.Handler;
import android.support.annotation.NonNull;
import com.codewaves.youtubethumbnailview.ImageLoader;
import com.codewaves.youtubethumbnailview.ThumbnailDownloadListener;
import com.codewaves.youtubethumbnailview.VideoInfo;
import com.codewaves.youtubethumbnailview.downloader.VideoInfoDownloader;
import java.io.IOException;

class ThumbnailTask
implements Runnable {
    private final String url;
    private final int minThumbnailWidth;
    private final VideoInfoDownloader infoDownloader;
    private final ImageLoader imageLoader;
    private final ThumbnailDownloadListener listener;
    private final Handler handler;

    ThumbnailTask(@NonNull String url, int minThumbnailWidth, @NonNull VideoInfoDownloader infoDownloader, @NonNull ImageLoader imageLoader, @NonNull ThumbnailDownloadListener listener, @NonNull Handler handler) {
        this.url = url;
        this.minThumbnailWidth = minThumbnailWidth;
        this.infoDownloader = infoDownloader;
        this.imageLoader = imageLoader;
        this.listener = listener;
        this.handler = handler;
    }

    @Override
    public void run() {
        try {
            final VideoInfo info = this.infoDownloader.download(this.url, this.minThumbnailWidth);
            final Bitmap bitmap = this.imageLoader.load(info.getThumbnailUrl());
            this.postTask(new Runnable(){

                @Override
                public void run() {
                    ThumbnailTask.this.listener.onDownloadFinished(info, bitmap);
                }
            });
        }
        catch (IOException e) {
            this.postFailure(e);
        }
        catch (Exception e) {
            this.postFailure(e);
        }
    }

    private void postFailure(final @NonNull Throwable failCause) {
        this.postTask(new Runnable(){

            @Override
            public void run() {
                ThumbnailTask.this.listener.onDownloadFailed(failCause);
            }
        });
    }

    private void postTask(@NonNull Runnable task) {
        this.handler.post(task);
    }
}

