/*
 * Decompiled with CFR 0.152.
 */
package com.codesgood.views;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class JustifiedTextView
extends TextView {
    private static final String HAIR_SPACE = "\u200a";
    private static final String NORMAL_SPACE = " ";
    private int viewWidth;
    private List<String> sentences = new ArrayList<String>();
    private List<String> currentSentence = new ArrayList<String>();
    private List<String> sentenceWithSpaces = new ArrayList<String>();
    private String justifiedText = "";
    private Random random = new Random();

    public JustifiedTextView(Context context) {
        super(context);
    }

    public JustifiedTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public JustifiedTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onDraw(Canvas canvas) {
        if (!this.justifiedText.equals(this.getText().toString())) {
            ViewGroup.LayoutParams params = this.getLayoutParams();
            String text = this.getText().toString();
            this.viewWidth = this.getMeasuredWidth() - (this.getPaddingLeft() + this.getPaddingRight());
            if (params.width != -2 && this.viewWidth > 0 && !text.isEmpty()) {
                this.justifiedText = this.getJustifiedText(text);
                if (!this.justifiedText.isEmpty()) {
                    this.setText(this.justifiedText);
                    this.sentences.clear();
                    this.currentSentence.clear();
                }
            } else {
                super.onDraw(canvas);
            }
        } else {
            super.onDraw(canvas);
        }
    }

    private String getJustifiedText(String text) {
        String[] words;
        for (String word : words = text.split(NORMAL_SPACE)) {
            boolean containsNewLine;
            boolean bl = containsNewLine = word.contains("\n") || word.contains("\r");
            if (this.fitsInSentence(word, this.currentSentence, true)) {
                this.addWord(word, containsNewLine);
                continue;
            }
            this.sentences.add(this.fillSentenceWithSpaces(this.currentSentence));
            this.currentSentence.clear();
            this.addWord(word, containsNewLine);
        }
        if (this.currentSentence.size() > 0) {
            this.sentences.add(this.getSentenceFromList(this.currentSentence, true));
        }
        return this.getSentenceFromList(this.sentences, false);
    }

    private void addWord(String word, boolean containsNewLine) {
        this.currentSentence.add(word);
        if (containsNewLine) {
            this.sentences.add(this.getSentenceFromListCheckingNewLines(this.currentSentence));
            this.currentSentence.clear();
        }
    }

    private String getSentenceFromList(List<String> strings, boolean addSpaces) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : strings) {
            stringBuilder.append(string);
            if (!addSpaces) continue;
            stringBuilder.append(NORMAL_SPACE);
        }
        return stringBuilder.toString();
    }

    private String getSentenceFromListCheckingNewLines(List<String> strings) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : strings) {
            stringBuilder.append(string);
            if (string.contains("\n") || string.contains("\r")) continue;
            stringBuilder.append(NORMAL_SPACE);
        }
        return stringBuilder.toString();
    }

    private String fillSentenceWithSpaces(List<String> sentence) {
        this.sentenceWithSpaces.clear();
        if (sentence.size() > 1) {
            for (String word : sentence) {
                this.sentenceWithSpaces.add(word);
                this.sentenceWithSpaces.add(NORMAL_SPACE);
            }
            while (this.fitsInSentence(HAIR_SPACE, this.sentenceWithSpaces, false)) {
                this.sentenceWithSpaces.add(this.getRandomNumber(this.sentenceWithSpaces.size() - 2), HAIR_SPACE);
            }
        }
        return this.getSentenceFromList(this.sentenceWithSpaces, false);
    }

    private boolean fitsInSentence(String word, List<String> sentence, boolean addSpaces) {
        String stringSentence = this.getSentenceFromList(sentence, addSpaces);
        stringSentence = stringSentence + word;
        float sentenceWidth = this.getPaint().measureText(stringSentence);
        return sentenceWidth < (float)this.viewWidth;
    }

    private int getRandomNumber(int max) {
        return this.random.nextInt(max) + 1;
    }
}

