/*
 * Decompiled with CFR 0.152.
 */
package com.coderconsole.cextracter.cquery.base;

import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import com.coderconsole.cextracter.cquery.base.AbstractContactListExtractor;
import com.coderconsole.cextracter.cquery.base.BaseContactQueryCB;
import com.coderconsole.cextracter.cquery.base.CList;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CListExtractorAbstract
extends AbstractContactListExtractor {
    private static final String TAG = CListExtractorAbstract.class.getSimpleName();
    private final Context mContext;

    public CListExtractorAbstract(Context mContext) {
        super(mContext);
        this.mContext = mContext;
    }

    public Single<List<CList>> getList(final int mFilterType, final String orderBy, String limit, String skip) {
        return Single.create((SingleOnSubscribe)new SingleOnSubscribe<List<CList>>(){

            public void subscribe(SingleEmitter<List<CList>> emitter) throws Exception {
                Cursor fetchCursor = CListExtractorAbstract.this.getCursorByType(mFilterType, orderBy);
                if (fetchCursor == null) {
                    emitter.onError((Throwable)new Exception("Cursor is null"));
                    return;
                }
                Log.d((String)TAG, (String)("|Start Filter Type  = " + mFilterType + " " + new Date(System.currentTimeMillis()).toString() + "\n Cursor Count" + fetchCursor.getCount()));
                emitter.onSuccess(new ArrayList(CListExtractorAbstract.this.fillMap(fetchCursor, mFilterType).values()));
            }
        });
    }

    private Map<String, CList> fillMap(Cursor fetchCursor, int mFilterType) {
        HashMap<String, CList> cListMap = new HashMap<String, CList>();
        while (fetchCursor.moveToNext()) {
            CList cList;
            String _id = null;
            String contactId = null;
            switch (mFilterType) {
                case 0: {
                    _id = fetchCursor.getString(fetchCursor.getColumnIndex("_id"));
                    contactId = fetchCursor.getString(fetchCursor.getColumnIndex("contact_id"));
                    break;
                }
                case 1: {
                    _id = fetchCursor.getString(fetchCursor.getColumnIndex("_id"));
                    contactId = fetchCursor.getString(fetchCursor.getColumnIndex("contact_id"));
                    break;
                }
                case 2: {
                    _id = fetchCursor.getString(fetchCursor.getColumnIndex("_id"));
                    contactId = fetchCursor.getString(fetchCursor.getColumnIndex("contact_id"));
                    break;
                }
                case 3: {
                    _id = fetchCursor.getString(fetchCursor.getColumnIndex("_id"));
                    contactId = fetchCursor.getString(fetchCursor.getColumnIndex("contact_id"));
                    break;
                }
                case 4: {
                    _id = fetchCursor.getString(fetchCursor.getColumnIndex("_id"));
                    contactId = fetchCursor.getString(fetchCursor.getColumnIndex("contact_id"));
                    break;
                }
                case 5: {
                    _id = fetchCursor.getString(fetchCursor.getColumnIndex("_id"));
                    contactId = fetchCursor.getString(fetchCursor.getColumnIndex("contact_id"));
                    break;
                }
                case 7: {
                    _id = fetchCursor.getString(fetchCursor.getColumnIndex("_id"));
                    contactId = fetchCursor.getString(fetchCursor.getColumnIndex("contact_id"));
                    break;
                }
                case 8: {
                    contactId = _id = fetchCursor.getString(fetchCursor.getColumnIndex("_id"));
                    break;
                }
            }
            if (cListMap.containsKey(contactId)) {
                cList = (CList)cListMap.get(contactId);
            } else {
                cList = new CList();
                cList.setId(_id);
                cList.setContactId(contactId);
            }
            BaseContactQueryCB iContactQuery = new BaseContactQueryCB(this.mContext, fetchCursor, cList, null);
            cList = this.queryFilterType(iContactQuery, mFilterType, cList);
            cListMap.put(contactId, cList);
        }
        Log.d((String)TAG, (String)("|End" + new Date(System.currentTimeMillis()).toString() + "\n Count" + cListMap.values().size()));
        if (!fetchCursor.isClosed()) {
            fetchCursor.close();
        }
        return cListMap;
    }
}

