/*
 * Decompiled with CFR 0.152.
 */
package com.coderconsole.cextracter.cquery.base;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.text.TextUtils;
import com.coderconsole.cextracter.cmodels.CAccount;
import com.coderconsole.cextracter.cmodels.CEmail;
import com.coderconsole.cextracter.cmodels.CEvents;
import com.coderconsole.cextracter.cmodels.CGroups;
import com.coderconsole.cextracter.cmodels.CName;
import com.coderconsole.cextracter.cmodels.COrganisation;
import com.coderconsole.cextracter.cmodels.CPhone;
import com.coderconsole.cextracter.cmodels.CPostBoxCity;
import com.coderconsole.cextracter.cmodels.ContactGenericType;
import com.coderconsole.cextracter.cquery.base.CList;
import com.coderconsole.cextracter.i.IContactQuery;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class BaseContactQueryCB
implements IContactQuery {
    private static final String TAG = BaseContactQueryCB.class.getSimpleName();
    private Context context;
    private String identity;
    private Cursor cursor;
    private CList cList;

    BaseContactQueryCB(Context context, Cursor cursor, CList cList, String identity) {
        this.context = context;
        this.identity = identity;
        this.cursor = cursor;
        this.cList = cList;
    }

    ContentResolver getCR() {
        return this.context.getContentResolver();
    }

    @Override
    public CEmail getEmail() {
        CEmail email = this.cList.getcEmail();
        if (email == null) {
            email = new CEmail();
        }
        HashSet<String> home = email.getHome();
        HashSet<String> work = email.getWork();
        HashSet<String> mobile = email.getMobile();
        HashSet<String> other = email.getOther();
        int type = this.cursor.getInt(this.cursor.getColumnIndex("data2"));
        String data = this.cursor.getString(this.cursor.getColumnIndex("data1"));
        String photoUri = this.cursor.getString(this.cursor.getColumnIndex("photo_uri"));
        String displayName = this.cursor.getString(this.cursor.getColumnIndex("data4"));
        switch (type) {
            case 2: {
                work.add(data);
                break;
            }
            case 1: {
                home.add(data);
                break;
            }
            case 4: {
                mobile.add(data);
                break;
            }
            default: {
                other.add(data);
            }
        }
        if (work.size() == 0 && home.size() == 0 && mobile.size() == 0 && other.size() == 0) {
            return null;
        }
        CEmail cEmail = new CEmail();
        cEmail.setWork(work);
        cEmail.setHome(home);
        cEmail.setMobile(mobile);
        cEmail.setOther(other);
        cEmail.setPhotoUri(photoUri);
        return cEmail;
    }

    @Override
    public CPhone getPhone() {
        CPhone cPhone = this.cList.getcPhone();
        if (cPhone == null) {
            cPhone = new CPhone();
        }
        HashSet<String> homeSet = cPhone.getHome();
        HashSet<String> workSet = cPhone.getWork();
        HashSet<String> mobileSet = cPhone.getMobile();
        HashSet<String> otherSet = cPhone.getMobile();
        String phoneNo = this.cursor.getString(this.cursor.getColumnIndex("data1"));
        String numberType = this.cursor.getString(this.cursor.getColumnIndex("data2"));
        String displayName = this.cursor.getString(this.cursor.getColumnIndex("display_name"));
        String photoUri = this.cursor.getString(this.cursor.getColumnIndex("photo_uri"));
        if (!this.isValidType(numberType)) {
            return cPhone;
        }
        switch (Integer.valueOf(numberType)) {
            case 1: {
                homeSet.add(phoneNo);
                break;
            }
            case 3: {
                workSet.add(phoneNo);
                break;
            }
            case 2: {
                mobileSet.add(phoneNo);
                break;
            }
            default: {
                otherSet.add(phoneNo);
            }
        }
        cPhone.setHome(homeSet);
        cPhone.setMobile(mobileSet);
        cPhone.setWork(workSet);
        cPhone.setOther(otherSet);
        cPhone.setDisplayName(displayName);
        cPhone.setPhotoUri(photoUri);
        return cPhone;
    }

    private boolean isValidType(String numberType) {
        return !TextUtils.isEmpty((CharSequence)numberType) && TextUtils.isDigitsOnly((CharSequence)numberType);
    }

    @Override
    public CAccount getAccount() {
        CAccount cAccount = new CAccount();
        ArrayList<ContactGenericType> mContactGenericType = new ArrayList<ContactGenericType>();
        String accountName = this.cursor.getString(this.cursor.getColumnIndex("account_name"));
        String accountType = this.cursor.getString(this.cursor.getColumnIndex("account_type"));
        mContactGenericType.add(new ContactGenericType(accountName, accountType));
        cAccount.setmGenericType(mContactGenericType);
        return cAccount;
    }

    @Override
    public CPostBoxCity getPostCode() {
        CPostBoxCity cPostBoxCityList = this.cList.getcPostCode();
        if (cPostBoxCityList == null) {
            cPostBoxCityList = new CPostBoxCity();
        }
        List<CPostBoxCity.PostCity> cPostCode = cPostBoxCityList.getmPostCity();
        String poBox = this.cursor.getString(this.cursor.getColumnIndex("data5"));
        String city = this.cursor.getString(this.cursor.getColumnIndex("data7"));
        String photoUri = this.cursor.getString(this.cursor.getColumnIndex("photo_uri"));
        String displayName = this.cursor.getString(this.cursor.getColumnIndex("display_name"));
        CPostBoxCity.PostCity postCity = new CPostBoxCity.PostCity();
        postCity.setCity(city);
        postCity.setPost(poBox);
        cPostCode.add(postCity);
        cPostBoxCityList.setPhotoUri(photoUri);
        cPostBoxCityList.setDisplayName(displayName);
        cPostBoxCityList.setmPostCity(cPostCode);
        return cPostBoxCityList;
    }

    @Override
    public CName getName() {
        CName cName = new CName();
        String familyName = this.cursor.getString(this.cursor.getColumnIndex("data3"));
        String displayName = this.cursor.getString(this.cursor.getColumnIndex("data1"));
        String givenName = this.cursor.getString(this.cursor.getColumnIndex("data2"));
        String photoUri = this.cursor.getString(this.cursor.getColumnIndex("photo_uri"));
        cName.setFamilyName(familyName);
        cName.setDisplayName(displayName);
        cName.setGivenName(givenName);
        cName.setPhotoUri(photoUri);
        return cName;
    }

    @Override
    public COrganisation getOrg() {
        COrganisation cOrganisation = this.cList.getcOrg();
        if (cOrganisation == null) {
            cOrganisation = new COrganisation();
        }
        List<COrganisation.CompanyDepart> companyDeparts = cOrganisation.getCompanyOrgList();
        COrganisation.CompanyDepart depart = new COrganisation.CompanyDepart();
        depart.setCompany(this.cursor.getString(this.cursor.getColumnIndex("data1")));
        depart.setOrg(this.cursor.getString(this.cursor.getColumnIndex("data5")));
        companyDeparts.add(depart);
        cOrganisation.setCompanyOrgList(companyDeparts);
        cOrganisation.setDisplayName(this.cursor.getString(this.cursor.getColumnIndex("display_name")));
        cOrganisation.setPhotoUri(this.cursor.getString(this.cursor.getColumnIndex("photo_uri")));
        return cOrganisation;
    }

    @Override
    public CEvents getEvents() {
        CEvents cEvents = new CEvents();
        String startData = this.cursor.getString(this.cursor.getColumnIndex("data1"));
        int type = this.cursor.getInt(this.cursor.getColumnIndex("data2"));
        switch (type) {
            case 1: {
                cEvents.setAnniversay(startData);
                break;
            }
            case 3: {
                cEvents.setBirthDay(startData);
                break;
            }
        }
        cEvents.setDisplayName(this.cursor.getString(this.cursor.getColumnIndex("display_name")));
        cEvents.setPhotoUri(this.cursor.getString(this.cursor.getColumnIndex("photo_uri")));
        return cEvents;
    }

    @Override
    public CGroups getGroups() {
        CGroups cGroups = this.cList.getcGroups();
        if (cGroups == null) {
            cGroups = new CGroups();
        }
        HashSet<CGroups.BaseGroups> baseGroupsList = cGroups.getmList();
        CGroups.BaseGroups baseGroups = new CGroups.BaseGroups();
        baseGroups.setId(this.cursor.getInt(this.cursor.getColumnIndex("_id")));
        baseGroups.setTitle(this.cursor.getString(this.cursor.getColumnIndex("title")));
        baseGroupsList.add(baseGroups);
        cGroups.setmList(baseGroupsList);
        return cGroups;
    }

    @Override
    public String getPhotoUri() {
        return this.cursor.getString(this.cursor.getColumnIndex("photo_uri"));
    }
}

