/*
 * Decompiled with CFR 0.152.
 */
package com.coderconsole.cextracter.cquery.base;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;
import android.text.TextUtils;
import com.coderconsole.cextracter.cquery.base.CList;
import com.coderconsole.cextracter.i.IContactQuery;

public abstract class AbstractContactListExtractor {
    private Context mContext;
    private static final String TAG = AbstractContactListExtractor.class.getSimpleName();

    public AbstractContactListExtractor(Context mContext) {
        this.mContext = mContext;
    }

    protected CList queryFilterType(IContactQuery icQuery, int mFilterType, CList cList) {
        switch (mFilterType) {
            case 3: {
                cList.setcAccount(icQuery.getAccount());
                break;
            }
            case 1: {
                cList.setcEmail(icQuery.getEmail());
                break;
            }
            case 2: {
                cList.setcPhone(icQuery.getPhone());
                break;
            }
            case 0: {
                cList.setcName(icQuery.getName());
                break;
            }
            case 7: {
                cList.setcEvents(icQuery.getEvents());
                break;
            }
            case 5: {
                cList.setcOrg(icQuery.getOrg());
                break;
            }
            case 4: {
                cList.setcPostCode(icQuery.getPostCode());
                break;
            }
            case 8: {
                cList.setcGroups(icQuery.getGroups());
                break;
            }
        }
        return cList;
    }

    private String getOrderByQuery(String orderBy, String limit, String skip, String defaultOrderBy) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(!TextUtils.isEmpty((CharSequence)orderBy) ? orderBy : defaultOrderBy + " ASC ");
        sBuilder.append(!TextUtils.isEmpty((CharSequence)limit) && TextUtils.isDigitsOnly((CharSequence)limit) ? " limit " + limit + " " : " ");
        sBuilder.append(!TextUtils.isEmpty((CharSequence)skip) && TextUtils.isDigitsOnly((CharSequence)skip) ? " offset " + skip + " " : " ");
        return sBuilder.toString();
    }

    protected Cursor getCursorByType(int type) {
        return this.getCursorByType(type, null);
    }

    protected Cursor getCursorByType(int type, String orderBy) {
        return this.getCursorByType(type, orderBy, null);
    }

    protected Cursor getCursorByType(int type, String orderBy, String limit) {
        return this.getCursorByType(type, orderBy, limit, null);
    }

    protected Cursor getCursorByType(int type, String orderBy, String limit, String skip) {
        Uri CONTENT_URI;
        String selection = null;
        String[] selectionArgs = null;
        String[] projections = null;
        switch (type) {
            case 1: {
                CONTENT_URI = ContactsContract.CommonDataKinds.Email.CONTENT_URI;
                selection = "data1 != '' AND data1 NOT NULL";
                orderBy = this.getOrderByQuery(orderBy, limit, skip, "data1");
                break;
            }
            case 0: {
                CONTENT_URI = ContactsContract.Data.CONTENT_URI;
                selection = "mimetype = ?";
                selectionArgs = new String[]{"vnd.android.cursor.item/name"};
                orderBy = this.getOrderByQuery(orderBy, limit, skip, "data1");
                break;
            }
            case 3: {
                CONTENT_URI = ContactsContract.RawContacts.CONTENT_URI;
                orderBy = this.getOrderByQuery(orderBy, limit, skip, "contact_id");
                break;
            }
            case 4: {
                CONTENT_URI = ContactsContract.CommonDataKinds.StructuredPostal.CONTENT_URI;
                orderBy = this.getOrderByQuery(orderBy, limit, skip, "contact_id");
                break;
            }
            case 5: {
                CONTENT_URI = ContactsContract.Data.CONTENT_URI;
                selection = "mimetype = ?";
                selectionArgs = new String[]{"vnd.android.cursor.item/organization"};
                orderBy = this.getOrderByQuery(orderBy, limit, skip, "contact_id");
                break;
            }
            case 7: {
                CONTENT_URI = ContactsContract.Data.CONTENT_URI;
                selection = "mimetype = ?";
                selectionArgs = new String[]{"vnd.android.cursor.item/contact_event"};
                orderBy = this.getOrderByQuery(orderBy, limit, skip, "contact_id");
                break;
            }
            case 8: {
                CONTENT_URI = ContactsContract.Groups.CONTENT_URI;
                orderBy = this.getOrderByQuery(orderBy, limit, skip, "_id");
                break;
            }
            case 2: {
                CONTENT_URI = ContactsContract.CommonDataKinds.Phone.CONTENT_URI;
                orderBy = this.getOrderByQuery(orderBy, limit, skip, "display_name");
                break;
            }
            default: {
                CONTENT_URI = ContactsContract.CommonDataKinds.Phone.CONTENT_URI;
                orderBy = this.getOrderByQuery(orderBy, limit, skip, "display_name");
            }
        }
        return this.mContext.getContentResolver().query(CONTENT_URI, projections, selection, selectionArgs, orderBy);
    }
}

