/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack;

import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;

class ZippingSpliterator<L, R, O>
implements Spliterator<O> {
    private final Spliterator<L> lefts;
    private final Spliterator<R> rights;
    private final BiFunction<L, R, O> combiner;
    private boolean rightHadNext = false;

    static <L, R, O> Spliterator<O> zipping(Spliterator<L> lefts, Spliterator<R> rights, BiFunction<L, R, O> combiner) {
        return new ZippingSpliterator<L, R, O>(lefts, rights, combiner);
    }

    private ZippingSpliterator(Spliterator<L> lefts, Spliterator<R> rights, BiFunction<L, R, O> combiner) {
        this.lefts = lefts;
        this.rights = rights;
        this.combiner = combiner;
    }

    @Override
    public boolean tryAdvance(Consumer<? super O> action) {
        this.rightHadNext = false;
        boolean leftHadNext = this.lefts.tryAdvance((? super T l) -> this.rights.tryAdvance((? super T r) -> {
            this.rightHadNext = true;
            action.accept((O)this.combiner.apply(l, r));
        }));
        return leftHadNext && this.rightHadNext;
    }

    @Override
    public Spliterator<O> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Math.min(this.lefts.estimateSize(), this.rights.estimateSize());
    }

    @Override
    public int characteristics() {
        return this.lefts.characteristics() & this.rights.characteristics() & 0xFFFFFFFA;
    }
}

