/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack;

import com.codepoetics.protonpack.AggregatingSpliterator;
import com.codepoetics.protonpack.GroupRunsSpliterator;
import com.codepoetics.protonpack.Indexed;
import com.codepoetics.protonpack.InterleavingSpliterator;
import com.codepoetics.protonpack.MergingSpliterator;
import com.codepoetics.protonpack.SkipUntilSpliterator;
import com.codepoetics.protonpack.TakeWhileSpliterator;
import com.codepoetics.protonpack.TriZippingSpliterator;
import com.codepoetics.protonpack.UnfoldSpliterator;
import com.codepoetics.protonpack.WindowedSpliterator;
import com.codepoetics.protonpack.ZippingSpliterator;
import com.codepoetics.protonpack.functions.TriFunction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class StreamUtils {
    private StreamUtils() {
    }

    public static LongStream indices() {
        return LongStream.iterate(0L, l -> l + 1L);
    }

    public static <T> Stream<Indexed<T>> zipWithIndex(Stream<T> source) {
        return StreamUtils.zip(StreamUtils.indices().mapToObj(Long::valueOf), source, Indexed::index);
    }

    public static <L, R, O> Stream<O> zip(Stream<L> lefts, Stream<R> rights, BiFunction<L, R, O> combiner) {
        return StreamSupport.stream(ZippingSpliterator.zipping(lefts.spliterator(), rights.spliterator(), combiner), false);
    }

    public static <L, M, R, O> Stream<O> zip(Stream<L> lefts, Stream<M> middles, Stream<R> rights, TriFunction<L, M, R, O> combiner) {
        return StreamSupport.stream(TriZippingSpliterator.zipping(lefts.spliterator(), middles.spliterator(), rights.spliterator(), combiner), false);
    }

    private static boolean isSized(int characteristics) {
        return (characteristics & 0x40) != 0;
    }

    public static <T> Stream<T> takeWhile(Stream<T> source, Predicate<T> condition) {
        return StreamSupport.stream(TakeWhileSpliterator.over(source.spliterator(), condition), false);
    }

    public static <T> Stream<T> takeUntil(Stream<T> source, Predicate<T> condition) {
        return StreamUtils.takeWhile(source, condition.negate());
    }

    public static <T> Stream<T> skipWhile(Stream<T> source, Predicate<T> condition) {
        return StreamSupport.stream(SkipUntilSpliterator.over(source.spliterator(), condition.negate()), false);
    }

    public static <T> Stream<T> skipUntil(Stream<T> source, Predicate<T> condition) {
        return StreamSupport.stream(SkipUntilSpliterator.over(source.spliterator(), condition), false);
    }

    public static <T> Stream<T> unfold(T seed, Function<T, Optional<T>> generator) {
        return StreamSupport.stream(UnfoldSpliterator.over(seed, generator), false);
    }

    public static <T> Stream<List<T>> windowed(Stream<T> source, int windowSize) {
        return StreamUtils.windowed(source, windowSize, 1);
    }

    public static <T> Stream<List<T>> windowed(Stream<T> source, int windowSize, int skip) {
        return StreamUtils.windowed(source, windowSize, skip, false);
    }

    public static <T> Stream<List<T>> windowed(Stream<T> source, int windowSize, int skip, boolean allowLesserSize) {
        return StreamSupport.stream(WindowedSpliterator.over(source.spliterator(), windowSize, skip, allowLesserSize), false);
    }

    public static <T extends Comparable<T>> Stream<List<T>> groupRuns(Stream<T> source) {
        return StreamUtils.groupRuns(source, Comparable::compareTo);
    }

    public static <T> Stream<List<T>> groupRuns(Stream<T> source, Comparator<T> comparator) {
        return StreamSupport.stream(new GroupRunsSpliterator(source.spliterator(), comparator), false);
    }

    public static <T> Stream<T> interleave(Function<T[], Integer> selector, Stream<T> ... streams) {
        Spliterator[] spliterators = (Spliterator[])Stream.of(streams).map(s -> s.spliterator()).toArray(Spliterator[]::new);
        return StreamSupport.stream(InterleavingSpliterator.interleaving(spliterators, selector), false);
    }

    public static <T> Stream<T> interleave(Function<T[], Integer> selector, List<Stream<T>> streams) {
        Spliterator[] spliterators = (Spliterator[])streams.stream().map(s -> s.spliterator()).toArray(Spliterator[]::new);
        return StreamSupport.stream(InterleavingSpliterator.interleaving(spliterators, selector), false);
    }

    public static <T, O> Stream<O> merge(Supplier<O> unitSupplier, BiFunction<O, T, O> merger, Stream<T> ... streams) {
        Spliterator[] spliterators = (Spliterator[])Stream.of(streams).map(s -> s.spliterator()).toArray(Spliterator[]::new);
        return StreamSupport.stream(MergingSpliterator.merging(spliterators, unitSupplier, merger), false);
    }

    public static <T> Stream<List<T>> mergeToList(Stream<T> ... streams) {
        return StreamUtils.merge(ArrayList::new, (l, x) -> {
            l.add(x);
            return l;
        }, streams);
    }

    public static <T> Stream<T> reject(Stream<T> source, Predicate<? super T> predicate) {
        return source.filter(predicate.negate());
    }

    public static <T> Stream<List<T>> aggregate(Stream<T> source, BiPredicate<T, T> predicate) {
        return StreamSupport.stream(new AggregatingSpliterator<Object>(source.spliterator(), (a, e) -> a.isEmpty() || predicate.test(a.get(a.size() - 1), e)), false);
    }

    public static <T> Stream<List<T>> aggregate(Stream<T> source, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Positive size expected, was: " + size);
        }
        return StreamSupport.stream(new AggregatingSpliterator<Object>(source.spliterator(), (a, e) -> a.size() < size), false);
    }

    public static <T> Stream<List<T>> aggregateOnListCondition(Stream<T> source, BiPredicate<List<T>, T> predicate) {
        return StreamSupport.stream(new AggregatingSpliterator(source.spliterator(), predicate), false);
    }

    public static <T> Stream<T> streamNullable(T nullable) {
        return null == nullable ? Stream.empty() : Stream.of(nullable);
    }

    public static <T> Stream<T> stream(Optional<T> optional) {
        return optional.map(Stream::of).orElseGet(Stream::empty);
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }
}

