/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.drivercommands.WebdriversRegistry;
import com.codeborne.selenide.impl.WebDriverInstance;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeadThreadsWatchdog
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(DeadThreadsWatchdog.class);
    private final Collection<Thread> allWebDriverThreads;
    private final Map<Long, WebDriverInstance> driverPerThread;

    DeadThreadsWatchdog(Collection<Thread> allWebDriverThreads, Map<Long, WebDriverInstance> driverPerThread) {
        this.allWebDriverThreads = allWebDriverThreads;
        this.driverPerThread = driverPerThread;
        this.setDaemon(true);
        this.setName("Dead threads watchdog");
    }

    @Override
    public void run() {
        while (true) {
            this.closeUnusedWebdrivers();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    private void closeUnusedWebdrivers() {
        for (Thread thread : this.allWebDriverThreads) {
            if (thread.isAlive()) continue;
            this.closeWebDriver(thread);
        }
    }

    private void closeWebDriver(Thread thread) {
        this.allWebDriverThreads.remove(thread);
        WebDriverInstance driver = this.driverPerThread.remove(thread.getId());
        if (driver == null) {
            log.info("No webdriver found for thread: {} - nothing to close", (Object)thread.getId());
            return;
        }
        log.info("Thread {} is dead. Let's close its webdriver {}.", (Object)thread.getId(), (Object)driver.webDriver());
        driver.dispose();
        WebdriversRegistry.unregister((WebDriverInstance)driver);
    }
}

