/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SharedDownloadsFolder;
import com.codeborne.selenide.drivercommands.BrowserHealthChecker;
import com.codeborne.selenide.drivercommands.CreateDriverCommand;
import com.codeborne.selenide.drivercommands.WebdriversRegistry;
import com.codeborne.selenide.impl.DeadThreadsWatchdog;
import com.codeborne.selenide.impl.StaticConfig;
import com.codeborne.selenide.impl.WebDriverContainer;
import com.codeborne.selenide.impl.WebDriverInstance;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import com.codeborne.selenide.webdriver.WebDriverFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;
import org.openqa.selenium.support.events.WebDriverListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class WebDriverThreadLocalContainer
implements WebDriverContainer {
    private static final Logger log = LoggerFactory.getLogger(WebDriverThreadLocalContainer.class);
    private final List<WebDriverEventListener> eventListeners = new ArrayList<WebDriverEventListener>();
    private final List<WebDriverListener> listeners = new ArrayList<WebDriverListener>();
    final Collection<Thread> allWebDriverThreads = new ConcurrentLinkedQueue<Thread>();
    final Map<Long, WebDriverInstance> threadWebDriver = new ConcurrentHashMap<Long, WebDriverInstance>(4);
    @Nullable
    private Proxy userProvidedProxy;
    private final Config config = new StaticConfig();
    private final BrowserHealthChecker browserHealthChecker;
    private final WebDriverFactory factory = new WebDriverFactory();
    private final CreateDriverCommand createDriverCommand = new CreateDriverCommand();
    private final AtomicBoolean deadThreadsWatchdogStarted = new AtomicBoolean(false);

    public WebDriverThreadLocalContainer() {
        this(new BrowserHealthChecker());
    }

    WebDriverThreadLocalContainer(BrowserHealthChecker browserHealthChecker) {
        this.browserHealthChecker = browserHealthChecker;
    }

    @Override
    public void addListener(WebDriverEventListener listener) {
        this.eventListeners.add(listener);
    }

    @Override
    public void addListener(WebDriverListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(WebDriverEventListener listener) {
        this.eventListeners.remove(listener);
    }

    @Override
    public void removeListener(WebDriverListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setWebDriver(WebDriver webDriver) {
        this.setWebDriver(webDriver, null);
    }

    @Override
    public void setWebDriver(WebDriver webDriver, @Nullable SelenideProxyServer selenideProxy) {
        this.setWebDriver(webDriver, selenideProxy, (DownloadsFolder)new SharedDownloadsFolder(this.config.downloadsFolder()));
    }

    @Override
    public void setWebDriver(WebDriver webDriver, @Nullable SelenideProxyServer selenideProxy, DownloadsFolder browserDownloadsFolder) {
        this.resetWebDriver();
        this.setWebDriver(new WebDriverInstance(this.config, webDriver, selenideProxy, browserDownloadsFolder));
    }

    private long setWebDriver(WebDriverInstance webDriverInstance) {
        long threadId = Thread.currentThread().getId();
        this.threadWebDriver.put(threadId, webDriverInstance);
        return threadId;
    }

    @Override
    @Deprecated
    public void resetWebDriver() {
        this.threadWebDriver.remove(Thread.currentThread().getId());
    }

    @Override
    public void setProxy(@Nullable Proxy userProvidedProxy) {
        this.userProvidedProxy = userProvidedProxy;
    }

    @Override
    @CheckReturnValue
    public boolean hasWebDriverStarted() {
        return this.currentThreadDriver().map(driver -> driver.webDriver() != null).orElse(false);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebDriver getWebDriver() {
        return this.currentThreadDriver().map(WebDriverInstance::webDriver).orElseThrow(() -> new IllegalStateException("No webdriver is bound to current thread: " + Thread.currentThread().getId() + ". You need to call open(url) first."));
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebDriver getAndCheckWebDriver() {
        WebDriver webDriver = this.currentThreadDriver().map(WebDriverInstance::webDriver).orElse(null);
        if (webDriver == null) {
            log.info("No webdriver is bound to current thread: {} - let's create a new webdriver", (Object)Thread.currentThread().getId());
            return this.createAndRegisterDriver().webDriver();
        }
        if (this.browserHealthChecker.isBrowserStillOpen(webDriver)) {
            return webDriver;
        }
        if (!this.config.reopenBrowserOnFail()) {
            this.closeWebDriver();
            throw new IllegalStateException("Webdriver for current thread: " + Thread.currentThread().getId() + " has been closed meanwhile, and cannot create a new webdriver because reopenBrowserOnFail=false");
        }
        log.info("Webdriver has been closed meanwhile. Let's re-create it.");
        this.closeWebDriver();
        return this.createAndRegisterDriver().webDriver();
    }

    @Override
    @Nullable
    public DownloadsFolder getBrowserDownloadsFolder() {
        return this.currentThreadDriver().map(WebDriverInstance::downloadsFolder).orElse(null);
    }

    private Optional<WebDriverInstance> currentThreadDriver() {
        return Optional.ofNullable(this.threadWebDriver.get(Thread.currentThread().getId()));
    }

    @CheckReturnValue
    @Nonnull
    private WebDriverInstance createAndRegisterDriver() {
        WebDriverInstance driver = this.createDriver();
        long threadId = this.setWebDriver(driver);
        if (this.config.holdBrowserOpen()) {
            log.info("Browser and proxy will stay open due to holdBrowserOpen=true: {} -> {}, {}", new Object[]{threadId, driver.webDriver(), driver.proxy()});
        } else {
            this.markForAutoClose(Thread.currentThread());
        }
        return driver;
    }

    @CheckReturnValue
    @Nonnull
    private WebDriverInstance createDriver() {
        return this.createDriverCommand.createDriver(this.config, this.factory, this.userProvidedProxy, this.eventListeners, this.listeners);
    }

    @Override
    @CheckReturnValue
    @Nullable
    public SelenideProxyServer getProxyServer() {
        return this.currentThreadDriver().map(WebDriverInstance::proxy).orElse(null);
    }

    @Override
    public void closeWindow() {
        this.getWebDriver().close();
    }

    @Override
    public void closeWebDriver() {
        long threadId = Thread.currentThread().getId();
        WebDriverInstance driver = this.threadWebDriver.get(threadId);
        if (driver != null) {
            driver.dispose();
            WebdriversRegistry.unregister((WebDriverInstance)driver);
        }
        this.resetWebDriver();
    }

    @Override
    public void using(WebDriver driver, @Nullable SelenideProxyServer proxy, @Nullable DownloadsFolder downloadsFolder, Runnable lambda) {
        DownloadsFolder folder = downloadsFolder != null ? downloadsFolder : new SharedDownloadsFolder(this.config.downloadsFolder());
        this.using(new WebDriverInstance(this.config, driver, proxy, folder), lambda);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void using(WebDriverInstance webDriverInstance, Runnable lambda) {
        Optional<WebDriverInstance> previous = this.currentThreadDriver();
        this.setWebDriver(webDriverInstance);
        try {
            lambda.run();
        }
        finally {
            this.resetWebDriver();
            previous.ifPresent(this::setWebDriver);
        }
    }

    @Override
    public void inNewBrowser(Runnable lambda) {
        WebDriverInstance newBrowser = this.createDriver();
        try {
            this.using(newBrowser, lambda);
        }
        finally {
            newBrowser.dispose();
        }
    }

    @Override
    public void clearBrowserCache() {
        if (this.hasWebDriverStarted()) {
            this.getWebDriver().manage().deleteAllCookies();
        }
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getPageSource() {
        return this.getWebDriver().getPageSource();
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getCurrentUrl() {
        return this.getWebDriver().getCurrentUrl();
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getCurrentFrameUrl() {
        return Selenide.executeJavaScript("return window.location.href", new Object[0]).toString();
    }

    boolean isDeadThreadsWatchdogStarted() {
        return this.deadThreadsWatchdogStarted.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markForAutoClose(Thread thread) {
        this.allWebDriverThreads.add(thread);
        if (!this.isDeadThreadsWatchdogStarted()) {
            WebDriverThreadLocalContainer webDriverThreadLocalContainer = this;
            synchronized (webDriverThreadLocalContainer) {
                if (!this.isDeadThreadsWatchdogStarted()) {
                    new DeadThreadsWatchdog(this.allWebDriverThreads, this.threadWebDriver).start();
                    this.deadThreadsWatchdogStarted.set(true);
                }
            }
        }
    }
}

