/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideWait;
import com.codeborne.selenide.ex.AlertNotFoundException;
import com.codeborne.selenide.ex.FrameNotFoundException;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.ex.WindowNotFoundException;
import com.codeborne.selenide.impl.windows.FrameByIdOrName;
import com.codeborne.selenide.impl.windows.WindowByIndex;
import com.codeborne.selenide.impl.windows.WindowByNameOrHandle;
import java.time.Duration;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.Alert;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;

@ParametersAreNonnullByDefault
public class SelenideTargetLocator
implements WebDriver.TargetLocator {
    private final Driver driver;
    private final WebDriver webDriver;
    private final Config config;
    private final WebDriver.TargetLocator delegate;

    public SelenideTargetLocator(Driver driver) {
        this.driver = driver;
        this.config = driver.config();
        this.webDriver = driver.getWebDriver();
        this.delegate = this.webDriver.switchTo();
    }

    @Nonnull
    public WebDriver frame(int index) {
        try {
            return (WebDriver)this.Wait().until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((int)index));
        }
        catch (NoSuchElementException | TimeoutException e) {
            throw this.frameNotFoundError("No frame found with index: " + index, e);
        }
        catch (InvalidArgumentException e) {
            if (this.isFirefox62Bug(e) || this.isChrome75Error(e)) {
                throw this.frameNotFoundError("No frame found with index: " + index, e);
            }
            throw e;
        }
    }

    @Nonnull
    public WebDriver frame(String nameOrId) {
        try {
            return (WebDriver)this.Wait().until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((String)nameOrId));
        }
        catch (NoSuchElementException | TimeoutException e) {
            throw this.frameNotFoundError("No frame found with id/name: " + nameOrId, e);
        }
        catch (InvalidArgumentException e) {
            if (this.isFirefox62Bug(e)) {
                throw this.frameNotFoundError("No frame found with id/name: " + nameOrId, e);
            }
            throw e;
        }
    }

    @Nonnull
    public WebDriver frame(WebElement frameElement) {
        try {
            return (WebDriver)this.Wait().until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((WebElement)frameElement));
        }
        catch (NoSuchElementException | TimeoutException e) {
            throw this.frameNotFoundError("No frame found with element: " + frameElement, e);
        }
        catch (InvalidArgumentException e) {
            if (this.isFirefox62Bug(e)) {
                throw this.frameNotFoundError("No frame found with element: " + frameElement, e);
            }
            throw e;
        }
    }

    private boolean isFirefox62Bug(InvalidArgumentException e) {
        return e.getMessage().contains("untagged enum FrameId");
    }

    private boolean isChrome75Error(InvalidArgumentException e) {
        return e.getMessage().contains("invalid argument: 'id' out of range");
    }

    @Nonnull
    public WebDriver parentFrame() {
        return this.delegate.parentFrame();
    }

    @Nonnull
    public WebDriver defaultContent() {
        return this.delegate.defaultContent();
    }

    @Nonnull
    public WebElement activeElement() {
        return this.delegate.activeElement();
    }

    @Nonnull
    public Alert alert() {
        try {
            return (Alert)this.Wait().until((Function)ExpectedConditions.alertIsPresent());
        }
        catch (TimeoutException e) {
            throw this.alertNotFoundError(e);
        }
    }

    @Nonnull
    public WebDriver innerFrame(String ... frames) {
        this.delegate.defaultContent();
        for (String frame : frames) {
            try {
                this.Wait().until((Function)((Object)new FrameByIdOrName(frame)));
            }
            catch (NoSuchElementException | TimeoutException e) {
                throw this.frameNotFoundError("No frame found with id/name = " + frame, e);
            }
        }
        return this.webDriver;
    }

    @Nonnull
    public WebDriver window(int index) {
        try {
            return (WebDriver)this.Wait().until((Function)((Object)new WindowByIndex(index)));
        }
        catch (TimeoutException e) {
            throw this.windowNotFoundError("No window found with index: " + index, e);
        }
    }

    @Nonnull
    public WebDriver window(int index, Duration duration) {
        try {
            return (WebDriver)this.Wait(duration).until((Function)((Object)new WindowByIndex(index)));
        }
        catch (TimeoutException e) {
            throw this.windowNotFoundError("No window found with index: " + index, e);
        }
    }

    @Nonnull
    public WebDriver window(String nameOrHandleOrTitle) {
        try {
            return (WebDriver)this.Wait().until((Function)((Object)new WindowByNameOrHandle(nameOrHandleOrTitle)));
        }
        catch (TimeoutException e) {
            throw this.windowNotFoundError("No window found with name or handle or title: " + nameOrHandleOrTitle, e);
        }
    }

    @Nonnull
    public WebDriver window(String nameOrHandleOrTitle, Duration duration) {
        try {
            return (WebDriver)this.Wait(duration).until((Function)((Object)new WindowByNameOrHandle(nameOrHandleOrTitle)));
        }
        catch (TimeoutException e) {
            throw this.windowNotFoundError("No window found with name or handle or title: " + nameOrHandleOrTitle, e);
        }
    }

    private SelenideWait Wait() {
        return new SelenideWait(this.webDriver, this.config.timeout(), this.config.pollingInterval());
    }

    private SelenideWait Wait(Duration timeout) {
        return new SelenideWait(this.webDriver, timeout.toMillis(), this.config.pollingInterval());
    }

    private Error frameNotFoundError(String message, Throwable cause) {
        FrameNotFoundException error = new FrameNotFoundException(this.driver, message, cause);
        return UIAssertionError.wrap(this.driver, (Error)((Object)error), this.config.timeout());
    }

    private Error windowNotFoundError(String message, Throwable cause) {
        WindowNotFoundException error = new WindowNotFoundException(this.driver, message, cause);
        return UIAssertionError.wrap(this.driver, (Error)((Object)error), this.config.timeout());
    }

    private Error alertNotFoundError(Throwable cause) {
        AlertNotFoundException error = new AlertNotFoundException(this.driver, "Alert not found", cause);
        return UIAssertionError.wrap(this.driver, (Error)((Object)error), this.config.timeout());
    }
}

