/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;

public class MergeableCapabilities
extends MutableCapabilities {
    public MergeableCapabilities(Capabilities base, Capabilities extraCapabilities) {
        this.merge(base);
        this.merge(extraCapabilities);
    }

    public void setCapability(String key, Object value) {
        if (value instanceof Map) {
            this.setCapabilityMap(key, (Map)value);
        } else {
            super.setCapability(key, value);
        }
    }

    private void setCapabilityMap(String key, Map<String, Object> value) {
        Object previousValue = this.getCapability(key);
        if (previousValue == null) {
            super.setCapability(key, value);
        } else if (previousValue instanceof Map) {
            super.setCapability(key, this.mergeMaps((Map)previousValue, value));
        } else {
            throw new IllegalArgumentException("Cannot merge capability " + key + " of different types: " + value.getClass().getName() + " vs " + previousValue.getClass().getName());
        }
    }

    private Map<String, Object> mergeMaps(Map<String, Object> base, Map<String, Object> extra) {
        String key;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : base.entrySet()) {
            key = entry.getKey();
            Object baseValue = entry.getValue();
            Object extraValue = extra.get(key);
            result.put(key, this.merge(baseValue, extraValue));
        }
        for (Map.Entry<String, Object> entry : extra.entrySet()) {
            key = entry.getKey();
            if (result.containsKey(key)) continue;
            result.put(key, entry.getValue());
        }
        return result;
    }

    private Object merge(Object baseValue, Object extraValue) {
        if (extraValue == null) {
            return baseValue;
        }
        if (baseValue instanceof List && extraValue instanceof List) {
            return this.mergeLists((List)baseValue, (List)extraValue);
        }
        if (baseValue.getClass().isArray() && extraValue.getClass().isArray()) {
            return this.mergeArrays((Object[])baseValue, (Object[])extraValue);
        }
        if (baseValue.getClass().isArray() && extraValue instanceof List) {
            return this.mergeLists(Arrays.asList((Object[])baseValue), (List)extraValue);
        }
        if (baseValue instanceof List && extraValue.getClass().isArray()) {
            return this.mergeLists((List)baseValue, Arrays.asList((Object[])extraValue));
        }
        if (baseValue.getClass() != extraValue.getClass()) {
            throw new IllegalArgumentException("Cannot merge values of different types: " + baseValue + " vs " + extraValue);
        }
        return extraValue;
    }

    private List<Object> mergeLists(List<Object> base, List<Object> extra) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(base);
        result.addAll(extra);
        return result;
    }

    private Object[] mergeArrays(Object[] base, Object[] extra) {
        Object[] result = new Object[base.length + extra.length];
        System.arraycopy(base, 0, result, 0, base.length);
        System.arraycopy(extra, 0, result, base.length, extra.length);
        return result;
    }
}

