/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import java.util.Arrays;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Arguments {
    private final Object[] args;

    public Arguments(@Nullable Object[] args) {
        this.args = args;
    }

    public <T> T nth(int index) {
        if (this.args == null) {
            throw new IllegalArgumentException("Missing arguments");
        }
        if (index >= this.args.length) {
            throw new IllegalArgumentException("Missing argument #" + index + " in " + Arrays.toString(this.args));
        }
        return (T)this.args[index];
    }

    public int length() {
        return this.args == null ? 0 : this.args.length;
    }

    @CheckReturnValue
    @Nonnull
    public <T> Optional<T> ofType(@Nonnull Class<T> klass) {
        if (this.args == null) {
            return Optional.empty();
        }
        for (Object arg : this.args) {
            if (arg == null || !klass.isAssignableFrom(arg.getClass())) continue;
            return Optional.of(arg);
        }
        return Optional.empty();
    }
}

