/*
 * Decompiled with CFR 0.152.
 */
package play.modules.excel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.exceptions.UnexpectedException;
import play.mvc.Http;
import play.mvc.Scope;
import play.mvc.results.Result;
import play.vfs.VirtualFile;

public class RenderExcel
extends Result {
    private static final Logger logger = LoggerFactory.getLogger(RenderExcel.class);
    public static final String RA_FILENAME = "__FILE_NAME__";
    private final VirtualFile file;
    private final String fileName;
    private final Map<String, Object> beans;

    public RenderExcel(VirtualFile file, Map<String, Object> beans) {
        this(file, beans, null);
    }

    public RenderExcel(VirtualFile file, Map<String, Object> beans, String fileName) {
        this.file = file;
        this.beans = beans;
        this.fileName = fileName == null ? RenderExcel.fileName_(file.relativePath()) : fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    private static String fileName_(String path) {
        if (Scope.RenderArgs.current().data.containsKey(RA_FILENAME)) {
            return (String)Scope.RenderArgs.current().get(RA_FILENAME, String.class);
        }
        int i = path.lastIndexOf("/");
        if (-1 == i) {
            return path;
        }
        return path.substring(++i);
    }

    public void apply(Http.Request request, Http.Response response, Scope.Session session, Scope.RenderArgs renderArgs, Scope.Flash flash) {
        logger.debug("use sync excel rendering");
        try (InputStream is = this.file.inputstream();){
            long start = System.nanoTime();
            HashMap<String, Object> args = new HashMap<String, Object>(this.beans);
            Workbook workbook = new XLSTransformer().transformXLS(is, args);
            workbook.write((OutputStream)response.out);
            logger.debug("Excel sync render takes {}ms", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        }
        catch (IOException | InvalidFormatException e) {
            throw new UnexpectedException(e);
        }
    }

    public boolean isRenderingTemplate() {
        return true;
    }
}

