/*
 * Decompiled with CFR 0.152.
 */
package play.modules.excel;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.codec.net.URLCodec;
import play.PlayPlugin;
import play.exceptions.UnexpectedException;
import play.modules.excel.RenderExcel;
import play.mvc.Http;
import play.mvc.Scope;
import play.mvc.results.Result;
import play.templates.Template;
import play.vfs.VirtualFile;

public class Plugin
extends PlayPlugin {
    public static PlayPlugin templateLoader;
    private static final Pattern p_;
    private static final Pattern pIE678_;
    private static final URLCodec encoder;

    public Optional<Template> loadTemplate(VirtualFile file) {
        if (!p_.matcher(file.getName()).matches()) {
            return Optional.empty();
        }
        if (null == templateLoader) {
            return Optional.of(new ExcelTemplate(file));
        }
        return templateLoader.loadTemplate(file);
    }

    public void beforeActionInvocation(Http.Request request, Http.Response response, Scope.Session session, Scope.RenderArgs renderArgs, Scope.Flash flash, Method actionMethod) {
        Http.Header h = (Http.Header)request.headers.get("user-agent");
        if (null == h) {
            return;
        }
        String userAgent = h.value();
        if (pIE678_.matcher(userAgent).matches()) {
            return;
        }
        if (request.headers.get("accept") != null) {
            String accept = ((Http.Header)request.headers.get("accept")).value();
            if (accept.indexOf("text/csv") != -1) {
                request.format = "csv";
            }
            if (accept.matches(".*application\\/(excel|vnd\\.ms\\-excel|x\\-excel|x\\-msexcel).*")) {
                request.format = "xls";
            }
            if (accept.indexOf("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet") != -1) {
                request.format = "xlsx";
            }
        }
    }

    public void onActionInvocationResult(Http.Request request, Http.Response response, Scope.Session session, Scope.RenderArgs renderArgs, Result result) {
        if (null == request.format || !request.format.matches("(csv|xls|xlsx)")) {
            return;
        }
        if (!response.headers.containsKey("Content-Disposition")) {
            String fileName = (String)renderArgs.get("__FILE_NAME__", String.class);
            if (fileName == null) {
                response.setHeader("Content-Disposition", "attachment; filename=export." + request.format);
            } else {
                try {
                    response.setHeader("Content-Disposition", "attachment; filename=" + encoder.encode(fileName, "utf-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new UnexpectedException((Throwable)e);
                }
            }
            if ("xls".equals(request.format)) {
                response.setContentTypeIfNotSet("application/vnd.ms-excel");
            } else if ("xlsx".equals(request.format)) {
                response.setContentTypeIfNotSet("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            } else if ("csv".equals(request.format)) {
                response.setContentTypeIfNotSet("text/csv");
            }
        }
    }

    static {
        p_ = Pattern.compile(".*\\.(xls|xlsx)");
        pIE678_ = Pattern.compile(".*MSIE\\s+[6|7|8]\\.0.*");
        encoder = new URLCodec();
    }

    public static class ExcelTemplate
    extends Template {
        private VirtualFile file;
        private RenderExcel r_;

        public ExcelTemplate(VirtualFile file) {
            this.file = file;
            this.name = file.relativePath();
        }

        public ExcelTemplate(RenderExcel render) {
            this.r_ = render;
        }

        public void compile() {
            if (!this.file.getRealFile().canRead()) {
                throw new UnexpectedException("template file not readable: " + this.name);
            }
        }

        protected String internalRender(Map<String, Object> args) {
            throw null == this.r_ ? new RenderExcel(this.file, args) : this.r_;
        }
    }
}

