/*
 * Decompiled with CFR 0.152.
 */
package com.codearms.maoqiqi.lazyload;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

public abstract class LazyLoadFragment
extends Fragment {
    private String tag = ((Object)((Object)this)).getClass().getSimpleName();
    protected Context context;
    protected View rootView;
    private boolean isViewCreated = false;
    private boolean isLoadDataCompleted = false;
    private boolean isReuse = true;
    private boolean isForcedToRefresh = false;

    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        Log.d((String)this.tag, (String)("-->setUserVisibleHint(boolean isVisibleToUser) = " + isVisibleToUser));
        if (this.isViewCreated) {
            this.onVisibleChange(isVisibleToUser);
            if (isVisibleToUser && (!this.isLoadDataCompleted || this.isForcedToRefresh)) {
                this.isLoadDataCompleted = true;
                this.loadData();
            }
        }
    }

    public void onInflate(Context context, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(context, attrs, savedInstanceState);
        Log.d((String)this.tag, (String)"-->onInflate(Context context, AttributeSet attrs, Bundle savedInstanceState)");
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        Log.d((String)this.tag, (String)"-->onAttach(Context context)");
        this.context = context;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.d((String)this.tag, (String)"-->onCreate(@Nullable Bundle savedInstanceState)");
        if (savedInstanceState != null) {
            this.isLoadDataCompleted = savedInstanceState.getBoolean("isLoadDataCompleted", false);
            this.isReuse = savedInstanceState.getBoolean("isReuse", true);
            this.isForcedToRefresh = savedInstanceState.getBoolean("isForcedToRefresh", false);
            Log.d((String)this.tag, (String)("isLoadDataCompleted = " + this.isLoadDataCompleted + ", isReuse = " + this.isReuse + ", isForcedToRefresh = " + this.isForcedToRefresh));
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        Log.d((String)this.tag, (String)"-->onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState)");
        if (!this.isReuse || this.rootView == null) {
            Log.d((String)this.tag, (String)"-->\u521b\u5efaView");
            this.rootView = this.createView(inflater, container);
            this.initViews(savedInstanceState);
        } else {
            Log.d((String)this.tag, (String)"-->\u590d\u7528View");
        }
        return this.rootView;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        Log.d((String)this.tag, (String)"-->onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState)");
        this.isViewCreated = true;
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        Log.d((String)this.tag, (String)"-->onActivityCreated(@Nullable Bundle savedInstanceState)");
        if (this.getUserVisibleHint()) {
            this.onVisibleChange(true);
            if (!this.isLoadDataCompleted || this.isForcedToRefresh) {
                this.isLoadDataCompleted = true;
                this.loadData();
            }
        }
    }

    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        Log.d((String)this.tag, (String)"-->onViewStateRestored(@Nullable Bundle savedInstanceState)");
    }

    public void onStart() {
        super.onStart();
        Log.d((String)this.tag, (String)"-->onStart()");
    }

    public void onResume() {
        super.onResume();
        Log.d((String)this.tag, (String)"-->onResume()");
    }

    public void onPause() {
        super.onPause();
        Log.d((String)this.tag, (String)"-->onPause()");
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        Log.d((String)this.tag, (String)"-->onSaveInstanceState(@NonNull Bundle outState)");
        outState.putBoolean("isLoadDataCompleted", this.isLoadDataCompleted);
        outState.putBoolean("isReuse", this.isReuse);
        outState.putBoolean("isForcedToRefresh", this.isForcedToRefresh);
    }

    public void onStop() {
        super.onStop();
        Log.d((String)this.tag, (String)"-->onStop()");
    }

    public void onDestroyView() {
        super.onDestroyView();
        Log.d((String)this.tag, (String)"-->onDestroyView()");
        this.isViewCreated = false;
        this.rootView = null;
    }

    public void onDestroy() {
        super.onDestroy();
        Log.d((String)this.tag, (String)"-->onDestroy()");
    }

    public void onDetach() {
        super.onDetach();
        Log.d((String)this.tag, (String)"-->onDetach()");
        this.context = null;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        Log.d((String)this.tag, (String)"-->onConfigurationChanged(Configuration newConfig)");
    }

    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        Log.d((String)this.tag, (String)("-->onHiddenChanged(boolean hidden) = " + hidden));
    }

    public void setTag(String tag) {
        if (tag == null) {
            tag = ((Object)((Object)this)).getClass().getSimpleName();
        }
        this.tag = tag;
    }

    protected abstract View createView(@NonNull LayoutInflater var1, @Nullable ViewGroup var2);

    protected void initViews(@Nullable Bundle savedInstanceState) {
    }

    protected void onVisibleChange(boolean isVisible) {
        Log.d((String)this.tag, (String)("-->onVisibleChange(boolean isVisible) = " + isVisible));
    }

    protected void loadData() {
        Log.d((String)this.tag, (String)"-->loadData()");
    }

    public void setReuse(boolean reuse) {
        this.isReuse = reuse;
    }

    public void setForcedToRefresh(boolean forcedToRefresh) {
        this.isForcedToRefresh = forcedToRefresh;
    }
}

