/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter;

import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter.IFilter;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter.IFilterContext;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter.IFilterOutput;
import com.code_intelligence.jazzer.third_party.org.objectweb.asm.tree.AbstractInsnNode;
import com.code_intelligence.jazzer.third_party.org.objectweb.asm.tree.MethodNode;

public class KotlinGeneratedFilter
implements IFilter {
    static final String KOTLIN_METADATA_DESC = "Lkotlin/Metadata;";

    static boolean isKotlinClass(IFilterContext context) {
        return context.getClassAnnotations().contains(KOTLIN_METADATA_DESC);
    }

    @Override
    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        if (context.getSourceFileName() == null) {
            return;
        }
        if (!KotlinGeneratedFilter.isKotlinClass(context)) {
            return;
        }
        if (this.hasLineNumber(methodNode)) {
            return;
        }
        output.ignore(methodNode.instructions.getFirst(), methodNode.instructions.getLast());
    }

    private boolean hasLineNumber(MethodNode methodNode) {
        for (AbstractInsnNode i : methodNode.instructions) {
            if (15 != i.getType()) continue;
            return true;
        }
        return false;
    }
}

