/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.support;

import com.code_intelligence.jazzer.mutation.support.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public abstract class ParameterHolder {
    protected ParameterHolder() {
    }

    public AnnotatedType annotatedType() {
        return this.getMethod().getAnnotatedParameterTypes()[0];
    }

    public Type type() {
        return this.annotatedType().getType();
    }

    public Annotation[] parameterAnnotations() {
        return this.getMethod().getParameterAnnotations()[0];
    }

    private Method getMethod() {
        List foos = Arrays.stream(this.getClass().getDeclaredMethods()).filter(method -> method.getName().equals("foo")).collect(Collectors.toList());
        Preconditions.require(foos.size() == 1, this.getClass().getName() + " must define exactly one function named 'foo'");
        Method foo = (Method)foos.get(0);
        Preconditions.require(foo.getParameterCount() == 1, this.getClass().getName() + "#foo must define exactly one parameter");
        return foo;
    }
}

