/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.lang;

import com.code_intelligence.jazzer.mutation.annotation.WithLength;
import com.code_intelligence.jazzer.mutation.api.Debuggable;
import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.PseudoRandom;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.mutator.libfuzzer.LibFuzzerMutate;
import com.code_intelligence.jazzer.mutation.support.InputStreamSupport;
import com.code_intelligence.jazzer.mutation.support.RandomSupport;
import com.code_intelligence.jazzer.mutation.support.TypeSupport;
import com.google.errorprone.annotations.Immutable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.AnnotatedType;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;

final class ByteArrayMutatorFactory
extends MutatorFactory {
    ByteArrayMutatorFactory() {
    }

    @Override
    public Optional<SerializingMutator<?>> tryCreate(AnnotatedType type2, MutatorFactory factory) {
        Optional<WithLength> withLength = Optional.ofNullable(type2.getAnnotation(WithLength.class));
        int minLength = withLength.map(WithLength::min).orElse(0);
        int maxLength = withLength.map(WithLength::max).orElse(1000);
        return TypeSupport.findFirstParentIfClass(type2, byte[].class).map(parent -> new ByteArrayMutator(minLength, maxLength));
    }

    @Immutable
    private static final class ByteArrayMutator
    extends SerializingMutator<byte[]> {
        private static final int DEFAULT_MIN_LENGTH = 0;
        private static final int DEFAULT_MAX_LENGTH = 1000;
        private final int minLength;
        private final int maxLength;

        private ByteArrayMutator(int min, int max) {
            this.minLength = min;
            this.maxLength = max;
        }

        @Override
        public byte[] read(DataInputStream in) throws IOException {
            int length = RandomSupport.clamp(in.readInt(), this.minLength, this.maxLength);
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            return bytes;
        }

        @Override
        public byte[] readExclusive(InputStream in) throws IOException {
            return InputStreamSupport.readAllBytes(in);
        }

        @Override
        public void write(byte[] value, DataOutputStream out) throws IOException {
            out.writeInt(value.length);
            out.write(value);
        }

        @Override
        public void writeExclusive(byte[] value, OutputStream out) throws IOException {
            out.write(value);
        }

        @Override
        public byte[] detach(byte[] value) {
            return Arrays.copyOf(value, value.length);
        }

        @Override
        public byte[] init(PseudoRandom prng) {
            int len = prng.closedRange(this.minInitialSize(), this.maxInitialSize());
            byte[] bytes = new byte[len];
            prng.bytes(bytes);
            return bytes;
        }

        private int minInitialSize() {
            return this.minLength;
        }

        private int maxInitialSize() {
            return Math.min(this.minLength + 16, this.maxLength);
        }

        @Override
        public byte[] mutate(byte[] value, PseudoRandom prng) {
            int maxLengthIncrease = this.maxLength - value.length;
            byte[] mutated = LibFuzzerMutate.mutateDefault(value, maxLengthIncrease);
            return this.enforceLength(mutated);
        }

        private byte[] enforceLength(byte[] mutated) {
            if (mutated.length > this.maxLength) {
                return Arrays.copyOf(mutated, this.maxLength);
            }
            if (mutated.length < this.minLength) {
                return Arrays.copyOf(mutated, this.minLength);
            }
            return mutated;
        }

        @Override
        public byte[] crossOver(byte[] value, byte[] otherValue, PseudoRandom prng) {
            if (value.length == 0 || otherValue.length == 0) {
                return value;
            }
            byte[] out = null;
            block5: while (out == null) {
                switch (prng.indexIn(3)) {
                    case 0: {
                        out = ByteArrayMutator.intersect(value, otherValue, prng);
                        continue block5;
                    }
                    case 1: {
                        out = ByteArrayMutator.insertPart(value, otherValue, prng);
                        continue block5;
                    }
                    case 2: {
                        out = ByteArrayMutator.overwritePart(value, otherValue, prng);
                        continue block5;
                    }
                }
                throw new AssertionError((Object)"Invalid cross over function.");
            }
            return this.enforceLength(out);
        }

        private static byte[] intersect(byte[] value, byte[] otherValue, PseudoRandom prng) {
            int maxOutSize = prng.closedRange(0, Math.min(value.length, otherValue.length));
            byte[] out = new byte[maxOutSize];
            int outPos = 0;
            int valuePos = 0;
            int otherValuePos = 0;
            boolean usingFirstValue = true;
            while (outPos < out.length) {
                int extraSize;
                if (usingFirstValue && valuePos < value.length) {
                    extraSize = ByteArrayMutator.rndArraycopy(value, valuePos, out, outPos, prng);
                    outPos += extraSize;
                    valuePos += extraSize;
                } else if (!usingFirstValue && otherValuePos < otherValue.length) {
                    extraSize = ByteArrayMutator.rndArraycopy(otherValue, otherValuePos, out, outPos, prng);
                    outPos += extraSize;
                    otherValuePos += extraSize;
                }
                usingFirstValue = !usingFirstValue;
            }
            return out;
        }

        private static int rndArraycopy(byte[] val, int valPos, byte[] out, int outPos, PseudoRandom prng) {
            int outSizeLeft = out.length - outPos;
            int inSizeLeft = val.length - valPos;
            int maxExtraSize = Math.min(outSizeLeft, inSizeLeft);
            int extraSize = prng.closedRange(0, maxExtraSize);
            System.arraycopy(val, valPos, out, outPos, extraSize);
            return extraSize;
        }

        private static byte[] insertPart(byte[] value, byte[] otherValue, PseudoRandom prng) {
            int copySize = prng.closedRange(1, otherValue.length);
            int f = otherValue.length - copySize;
            int fromPos = f == 0 ? 0 : prng.indexIn(f);
            int toPos = prng.indexIn(value.length);
            int tailSize = value.length - toPos;
            byte[] out = new byte[value.length + copySize];
            System.arraycopy(value, 0, out, 0, toPos);
            System.arraycopy(otherValue, fromPos, out, toPos, copySize);
            System.arraycopy(value, toPos, out, toPos + copySize, tailSize);
            return out;
        }

        private static byte[] overwritePart(byte[] value, byte[] otherValue, PseudoRandom prng) {
            int toPos = prng.indexIn(value.length);
            int copySize = Math.min(prng.closedRange(1, value.length - toPos), otherValue.length);
            int f = otherValue.length - copySize;
            int fromPos = f == 0 ? 0 : prng.indexIn(f);
            System.arraycopy(otherValue, fromPos, value, toPos, copySize);
            return value;
        }

        @Override
        public boolean hasFixedSize() {
            return false;
        }

        @Override
        public String toDebugString(Predicate<Debuggable> isInCycle) {
            return "byte[]";
        }
    }
}

