/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.collection;

import com.code_intelligence.jazzer.mutation.api.PseudoRandom;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.api.ValueMutator;
import com.code_intelligence.jazzer.mutation.support.Preconditions;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class ChunkMutations {
    private static final int MAX_FAILED_INSERTION_ATTEMPTS = 100;
    private static final Object BOXED_NULL = new Object();

    private ChunkMutations() {
    }

    static <T> void deleteRandomChunk(List<T> list, int minSize, PseudoRandom prng, boolean hasFixedSize) {
        int oldSize = list.size();
        int minFinalSize = Math.max(minSize, oldSize / 2);
        int chunkSize = prng.sizeInClosedRange(1, oldSize - minFinalSize, hasFixedSize);
        int chunkOffset = prng.closedRange(0, oldSize - chunkSize);
        list.subList(chunkOffset, chunkOffset + chunkSize).clear();
    }

    static <T> void deleteRandomChunk(Collection<T> collection, int minSize, PseudoRandom prng, boolean hasFixedSize) {
        int i;
        int oldSize = collection.size();
        int minFinalSize = Math.max(minSize, oldSize / 2);
        int chunkSize = prng.sizeInClosedRange(1, oldSize - minFinalSize, hasFixedSize);
        int chunkOffset = prng.closedRange(0, oldSize - chunkSize);
        Iterator<T> it = collection.iterator();
        for (i = 0; i < chunkOffset; ++i) {
            it.next();
        }
        for (i = chunkOffset; i < chunkOffset + chunkSize; ++i) {
            it.next();
            it.remove();
        }
    }

    static <T> void insertRandomChunk(List<T> list, int maxSize, SerializingMutator<T> elementMutator, PseudoRandom prng) {
        int oldSize = list.size();
        int chunkSize = prng.sizeInClosedRange(1, maxSize - oldSize, elementMutator.hasFixedSize());
        int chunkOffset = prng.closedRange(0, oldSize);
        Object baseElement = elementMutator.init(prng);
        Object[] chunk = new Object[chunkSize];
        for (int i = 0; i < chunk.length; ++i) {
            chunk[i] = elementMutator.detach(baseElement);
        }
        list.addAll(chunkOffset, new ArraySharingList<Object>(chunk));
    }

    static <T> boolean insertRandomChunk(Set<T> set, Consumer<T> addIfNew, int maxSize, ValueMutator<T> elementMutator, PseudoRandom prng) {
        int oldSize = set.size();
        int chunkSize = prng.sizeInClosedRange(1, maxSize - oldSize, elementMutator.hasFixedSize());
        return ChunkMutations.growBy(set, addIfNew, chunkSize, () -> elementMutator.init(prng));
    }

    static <T> void mutateRandomChunk(List<T> list, ValueMutator<T> mutator, PseudoRandom prng) {
        int chunkOffset;
        int size = list.size();
        int chunkSize = prng.sizeInClosedRange(1, size, mutator.hasFixedSize());
        for (int i = chunkOffset = prng.closedRange(0, size - chunkSize); i < chunkOffset + chunkSize; ++i) {
            list.set(i, mutator.mutate(list.get(i), prng));
        }
    }

    static <K, V, KW, VW> boolean mutateRandomKeysChunk(Map<K, V> map, SerializingMutator<K> keyMutator, PseudoRandom prng) {
        int i;
        int originalSize = map.size();
        int chunkSize = prng.sizeInClosedRange(1, originalSize, keyMutator.hasFixedSize());
        int chunkOffset = prng.closedRange(0, originalSize - chunkSize);
        ArrayDeque keysToMutate = new ArrayDeque(chunkSize);
        ArrayDeque values2 = new ArrayDeque(chunkSize);
        ArrayList<K> keysToRemove = new ArrayList<K>(chunkSize);
        Iterator<Map.Entry<K, V>> it = map.entrySet().iterator();
        for (i = 0; i < chunkOffset; ++i) {
            it.next();
        }
        for (i = chunkOffset; i < chunkOffset + chunkSize; ++i) {
            Map.Entry<K, V> entry = it.next();
            keysToMutate.add(ChunkMutations.boxNull(keyMutator.detach(entry.getKey())));
            values2.add(ChunkMutations.boxNull(entry.getValue()));
            keysToRemove.add(entry.getKey());
        }
        Consumer<Object> addIfNew = key -> {
            int sizeBeforeAdd = map.size();
            map.putIfAbsent(key, ChunkMutations.unboxNull(values2.peekFirst()));
            if (map.size() > sizeBeforeAdd) {
                keysToMutate.removeFirst();
                values2.removeFirst();
            }
        };
        Supplier<Object> nextCandidate = () -> {
            Object candidate = keyMutator.mutate(ChunkMutations.unboxNull(keysToMutate.removeFirst()), prng);
            keysToMutate.addFirst(ChunkMutations.boxNull(candidate));
            return candidate;
        };
        ChunkMutations.growBy(map.keySet(), addIfNew, chunkSize, nextCandidate);
        int grownBy = map.size() - originalSize;
        keysToRemove.stream().limit(grownBy).forEach(map::remove);
        return grownBy > 0;
    }

    public static <K, V> void mutateRandomValuesChunk(Map<K, V> map, ValueMutator<V> valueMutator, PseudoRandom prng) {
        int i;
        Set<Map.Entry<K, V>> collection = map.entrySet();
        int oldSize = collection.size();
        int chunkSize = prng.sizeInClosedRange(1, oldSize, valueMutator.hasFixedSize());
        int chunkOffset = prng.closedRange(0, oldSize - chunkSize);
        Iterator it = collection.iterator();
        for (i = 0; i < chunkOffset; ++i) {
            it.next();
        }
        for (i = chunkOffset; i < chunkOffset + chunkSize; ++i) {
            Map.Entry entry = (Map.Entry)it.next();
            entry.setValue(valueMutator.mutate(entry.getValue(), prng));
        }
    }

    static <T> boolean growBy(Set<T> set, Consumer<T> addIfNew, int delta, Supplier<T> candidateSupplier) {
        int oldSize = set.size();
        Preconditions.require(delta >= 0);
        int targetSize = oldSize + delta;
        int remainingAttempts = 100;
        int currentSize = set.size();
        while (currentSize < targetSize) {
            addIfNew.accept(candidateSupplier.get());
            int newSize = set.size();
            if (newSize == currentSize && remainingAttempts-- == 0) {
                return false;
            }
            currentSize = newSize;
        }
        return true;
    }

    private static <T, TW> TW boxNull(T object) {
        return (TW)(object != null ? object : BOXED_NULL);
    }

    private static <T, TW> T unboxNull(TW object) {
        return (T)(object != BOXED_NULL ? object : null);
    }

    private static final class ArraySharingList<T>
    extends AbstractList<T> {
        private final T[] array;

        ArraySharingList(T[] array) {
            this.array = array;
        }

        @Override
        public T get(int i) {
            return this.array[i];
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Object[] toArray() {
            return this.array;
        }
    }

    public static enum MutationAction {
        DELETE_CHUNK,
        INSERT_CHUNK,
        MUTATE_CHUNK;


        public static MutationAction pickRandomMutationAction(Collection<?> c, int minSize, int maxSize, PseudoRandom prng) {
            ArrayList<MutationAction> actions = new ArrayList<MutationAction>();
            if (c.size() > minSize) {
                actions.add(DELETE_CHUNK);
            }
            if (c.size() < maxSize) {
                actions.add(INSERT_CHUNK);
            }
            if (!c.isEmpty()) {
                actions.add(MUTATE_CHUNK);
            }
            return (MutationAction)((Object)prng.pickIn(actions));
        }
    }
}

