/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.driver;

import com.code_intelligence.jazzer.driver.OptItem;
import com.code_intelligence.jazzer.utils.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class OptParser {
    private static final String[] HELP_HEADER = new String[]{"A coverage-guided, in-process fuzzer for the JVM", "", "Usage:", String.format("  java -cp jazzer.jar[%cclasspath_entries] com.code_intelligence.jazzer.Jazzer --target_class=<target class> [args...]", Character.valueOf(File.separatorChar)), String.format("  java -cp jazzer.jar[%cclasspath_entries] com.code_intelligence.jazzer.Jazzer --autofuzz=<method reference> [args...]", Character.valueOf(File.separatorChar)), "", "In addition to the options listed below, Jazzer also accepts all", "libFuzzer options described at:", "  https://llvm.org/docs/LibFuzzer.html#options", "", "Options:"};
    private static final List<OptItem<?>> knownArgs = new ArrayList();

    OptParser() {
    }

    static String getHelpText() {
        return Stream.concat(Arrays.stream(HELP_HEADER), knownArgs.stream().filter(Objects::nonNull).map(OptItem::toString)).collect(Collectors.joining("\n\n"));
    }

    static OptItem<String> stringSetting(String name, String defaultValue, String description2) {
        OptItem.Str opt = new OptItem.Str(name, defaultValue, description2);
        knownArgs.add(opt);
        return opt;
    }

    static OptItem<List<String>> stringListSetting(String name, String description2) {
        return OptParser.stringListSetting(name, File.pathSeparatorChar, description2);
    }

    static OptItem<List<String>> stringListSetting(String name, char separator, String description2) {
        OptItem.StrList opt = new OptItem.StrList(name, description2, separator, false);
        knownArgs.add(opt);
        return opt;
    }

    static OptItem<Boolean> boolSetting(String name, boolean defaultValue, String description2) {
        OptItem.Bool opt = new OptItem.Bool(name, Boolean.toString(defaultValue), description2);
        knownArgs.add(opt);
        return opt;
    }

    static OptItem<Long> uint64Setting(String name, long defaultValue, String description2) {
        OptItem.Uint64 opt = new OptItem.Uint64(name, Long.toUnsignedString(defaultValue), description2);
        knownArgs.add(opt);
        return opt;
    }

    static void registerAndValidateCommandLineArgs(List<Map.Entry<String, String>> cliArgs) {
        Set allowedArgs = knownArgs.stream().filter(optItem -> !optItem.isInternal()).map(OptItem::cliArgName).collect(Collectors.toSet());
        String invalidArgs = cliArgs.stream().map(Map.Entry::getKey).filter(arg -> !allowedArgs.contains(arg)).distinct().map(arg -> "--" + arg).collect(Collectors.joining(", "));
        if (!invalidArgs.isEmpty()) {
            Log.error("Unknown arguments (list available arguments with --help): " + invalidArgs);
            System.exit(1);
        }
        OptItem.registerCommandLineArgs(cliArgs);
    }

    public static void registerConfigurationParameters(Function<String, Optional<String>> configurationParameterGetter) {
        OptItem.registerConfigurationParameters(configurationParameterGetter);
    }
}

