/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class OptItem<T>
implements Supplier<T> {
    private static final String ROOT_SEGMENT = "jazzer";
    private static final String INTERNAL_SEGMENT = "internal";
    private static Optional<List<Map.Entry<String, String>>> cliArgs = Optional.empty();
    private static Optional<Function<String, Optional<String>>> configurationParameterGetter = Optional.empty();
    private final String name;
    private final String rawDefaultValue;
    private final String description;
    private T value;

    protected OptItem(String name, String defaultValue, String description2) {
        this.name = Objects.requireNonNull(name);
        this.rawDefaultValue = Objects.requireNonNull(defaultValue);
        this.description = description2;
    }

    static void registerCommandLineArgs(List<Map.Entry<String, String>> cliArgs) {
        if (OptItem.cliArgs.isPresent()) {
            throw new IllegalStateException("Command-line arguments have already been set");
        }
        OptItem.cliArgs = Optional.of(Collections.unmodifiableList(cliArgs.stream().map(e -> new AbstractMap.SimpleImmutableEntry<String, String>((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList())));
    }

    static void registerConfigurationParameters(Function<String, Optional<String>> configurationParameterGetter) {
        if (OptItem.configurationParameterGetter.isPresent()) {
            throw new IllegalStateException("Configuration parameters have already been set");
        }
        OptItem.configurationParameterGetter = Optional.of(configurationParameterGetter);
    }

    @Override
    public final T get() throws IllegalOptionValueException {
        Object localValue = this.value;
        if (localValue == null) {
            this.value = localValue = this.getExplicitValue().orElseGet(() -> this.fromStringOrThrow(this.rawDefaultValue, "default"));
        }
        return localValue;
    }

    public final boolean setIfDefault(T newValue) throws IllegalOptionValueException {
        if (this.value != null) {
            throw new IllegalStateException(String.format("Attempted to set of option %s to %s, but it has already been read elsewhere", this.propertyName(), newValue));
        }
        Optional<T> explicitValue = this.getExplicitValue();
        if (explicitValue.isPresent()) {
            this.value = explicitValue.get();
            return false;
        }
        this.value = newValue;
        return true;
    }

    final boolean isInternal() {
        return this.description == null;
    }

    public final String toString() {
        return String.format("--%s (%s, default: \"%s\")%n     %s", this.name, this.getType(), this.rawDefaultValue, this.description);
    }

    protected abstract Optional<T> fromString(String var1);

    protected abstract String getType();

    protected T accumulate(T oldValue, T newValue) {
        return newValue;
    }

    private Optional<T> getExplicitValue() {
        return Stream.of(this::getFromManifest, this::getFromEnv, this::getFromProperties, this::getFromConfigurationParameters, this::getFromCommandLineArguments).flatMap(Supplier::get).reduce(this::accumulate);
    }

    private Stream<T> getFromCommandLineArguments() {
        return cliArgs.orElse(Collections.emptyList()).stream().filter(e -> ((String)e.getKey()).equals(this.cliArgName())).map(Map.Entry::getValue).map(s -> this.fromStringOrThrow((String)s, "command-line argument " + this.cliArgName()));
    }

    private Stream<T> getFromConfigurationParameters() {
        return OptItem.stream(configurationParameterGetter.flatMap(getter -> (Optional)getter.apply(this.propertyName()))).map(s -> this.fromStringOrThrow((String)s, "configuration parameter " + this.propertyName()));
    }

    private Stream<T> getFromProperties() {
        return OptItem.stream(Optional.ofNullable(System.getProperty(this.propertyName(), null))).map(s -> this.fromStringOrThrow((String)s, "property " + this.propertyName()));
    }

    private Stream<T> getFromEnv() {
        return OptItem.stream(Optional.ofNullable(System.getenv(this.envVariableName()))).map(s -> this.fromStringOrThrow((String)s, "environment variable " + this.envVariableName()));
    }

    private Stream<T> getFromManifest() {
        try {
            ArrayList<URL> manifests = Collections.list(OptItem.class.getClassLoader().getResources("META-INF/MANIFEST.MF"));
            Collections.reverse(manifests);
            return manifests.stream().flatMap(url -> {
                Stream<Object> stream;
                block8: {
                    InputStream inputStream = url.openStream();
                    try {
                        stream = OptItem.stream(Optional.ofNullable(new Manifest(inputStream).getMainAttributes().getValue(this.manifestAttributeName()))).map(s -> this.fromStringOrThrow((String)s, String.format("manifest attribute %s in %s", this.manifestAttributeName(), url)));
                        if (inputStream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    inputStream.close();
                }
                return stream;
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private T fromStringOrThrow(String rawValue, String what) throws IllegalOptionValueException {
        return this.fromString(rawValue).orElseThrow(() -> new IllegalOptionValueException(String.format("Invalid value for %s: %s", what, rawValue)));
    }

    String cliArgName() {
        return this.name;
    }

    private String propertyName() {
        return this.segments().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.joining("."));
    }

    private String envVariableName() {
        return this.segments().map(s -> s.toUpperCase(Locale.ROOT)).collect(Collectors.joining("_"));
    }

    private String manifestAttributeName() {
        return this.segments().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.joining("_")).replace('_', '-');
    }

    private Stream<String> segments() {
        Stream.Builder<String> builder = Stream.builder().add(ROOT_SEGMENT);
        if (this.isInternal()) {
            builder.add(INTERNAL_SEGMENT);
        }
        builder.add(this.name);
        return builder.build();
    }

    private static <T> Stream<T> stream(Optional<T> optional) {
        return optional.map(Stream::of).orElseGet(Stream::empty);
    }

    public static class IllegalOptionValueException
    extends IllegalArgumentException {
        protected IllegalOptionValueException(String message) {
            super(message);
        }
    }

    public static final class StrList
    extends OptItem<List<String>> {
        private final char separator;
        private final boolean accumulate;

        StrList(String name, String description2, char separator, boolean accumulate) {
            super(name, "", description2);
            this.separator = separator;
            this.accumulate = accumulate;
        }

        @Override
        protected List<String> accumulate(List<String> oldValue, List<String> newValue) {
            if (this.accumulate) {
                return Collections.unmodifiableList(Stream.concat(oldValue.stream(), newValue.stream()).collect(Collectors.toList()));
            }
            return super.accumulate(oldValue, newValue);
        }

        @Override
        protected Optional<List<String>> fromString(String rawValue) {
            return Optional.of(StrList.splitOnUnescapedSeparator(rawValue, this.separator));
        }

        @Override
        protected String getType() {
            return String.format("list separated by '%s'", Character.valueOf(this.separator));
        }

        static List<String> splitOnUnescapedSeparator(String value, char separator) {
            if (separator == '\\') {
                throw new IllegalArgumentException("separator '\\' is not supported");
            }
            ArrayList<String> tokens = new ArrayList<String>();
            StringBuilder currentToken = new StringBuilder();
            boolean inEscapeState = false;
            for (int pos = 0; pos < value.length(); ++pos) {
                char c = value.charAt(pos);
                if (inEscapeState) {
                    currentToken.append(c);
                    inEscapeState = false;
                    continue;
                }
                if (c == '\\') {
                    inEscapeState = true;
                    continue;
                }
                if (c == separator) {
                    if (currentToken.length() > 0) {
                        tokens.add(currentToken.toString());
                    }
                    currentToken.setLength(0);
                    continue;
                }
                currentToken.append(c);
            }
            if (currentToken.length() > 0) {
                tokens.add(currentToken.toString());
            }
            return Collections.unmodifiableList(tokens);
        }
    }

    public static final class Str
    extends OptItem<String> {
        Str(String name, String defaultValue, String description2) {
            super(name, defaultValue, description2);
        }

        @Override
        protected Optional<String> fromString(String rawValue) throws IllegalOptionValueException {
            return Optional.of(rawValue);
        }

        @Override
        protected String getType() {
            return "string";
        }
    }

    public static final class Uint64
    extends OptItem<Long> {
        Uint64(String name, String defaultValue, String description2) {
            super(name, defaultValue, description2);
        }

        @Override
        protected Optional<Long> fromString(String rawValue) {
            try {
                return Optional.of(Long.parseUnsignedLong(rawValue));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }

        @Override
        protected String getType() {
            return "uint64";
        }
    }

    public static final class Bool
    extends OptItem<Boolean> {
        private static final List<String> TRUE_VALUES = Collections.unmodifiableList(Arrays.asList("true", "on", "yes", "y", "1"));
        private static final List<String> FALSE_VALUES = Collections.unmodifiableList(Arrays.asList("false", "off", "no", "n", "0"));

        Bool(String name, String defaultValue, String description2) {
            super(name, defaultValue, description2);
        }

        @Override
        protected Optional<Boolean> fromString(String rawValue) throws IllegalOptionValueException {
            if (TRUE_VALUES.stream().anyMatch(v -> v.equalsIgnoreCase(rawValue))) {
                return Optional.of(true);
            }
            if (FALSE_VALUES.stream().anyMatch(v -> v.equalsIgnoreCase(rawValue))) {
                return Optional.of(false);
            }
            throw new IllegalOptionValueException(String.format("Invalid value for boolean option %s: %s", this.cliArgName(), rawValue));
        }

        @Override
        protected String getType() {
            return "bool";
        }
    }
}

