/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis;

import com.code_intelligence.jazzer.third_party.org.jacoco.core.analysis.CoverageNodeImpl;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.analysis.IBundleCoverage;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.analysis.IClassCoverage;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.analysis.ICoverageNode;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.analysis.IPackageCoverage;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.analysis.ISourceFileCoverage;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.PackageCoverageImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class BundleCoverageImpl
extends CoverageNodeImpl
implements IBundleCoverage {
    private final Collection<IPackageCoverage> packages;

    public BundleCoverageImpl(String name, Collection<IPackageCoverage> packages2) {
        super(ICoverageNode.ElementType.BUNDLE, name);
        this.packages = packages2;
        this.increment(packages2);
    }

    public BundleCoverageImpl(String name, Collection<IClassCoverage> classes2, Collection<ISourceFileCoverage> sourcefiles) {
        this(name, BundleCoverageImpl.groupByPackage(classes2, sourcefiles));
    }

    private static Collection<IPackageCoverage> groupByPackage(Collection<IClassCoverage> classes2, Collection<ISourceFileCoverage> sourcefiles) {
        HashMap classesByPackage = new HashMap();
        for (IClassCoverage iClassCoverage : classes2) {
            BundleCoverageImpl.addByName(classesByPackage, iClassCoverage.getPackageName(), iClassCoverage);
        }
        HashMap sourceFilesByPackage = new HashMap();
        for (ISourceFileCoverage s : sourcefiles) {
            BundleCoverageImpl.addByName(sourceFilesByPackage, s.getPackageName(), s);
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(classesByPackage.keySet());
        hashSet.addAll(sourceFilesByPackage.keySet());
        ArrayList<IPackageCoverage> result = new ArrayList<IPackageCoverage>();
        for (String name : hashSet) {
            List<ISourceFileCoverage> s;
            List<IClassCoverage> c = (List<IClassCoverage>)classesByPackage.get(name);
            if (c == null) {
                c = Collections.emptyList();
            }
            if ((s = (List<ISourceFileCoverage>)sourceFilesByPackage.get(name)) == null) {
                s = Collections.emptyList();
            }
            result.add(new PackageCoverageImpl(name, c, s));
        }
        return result;
    }

    private static <T> void addByName(Map<String, Collection<T>> map, String name, T value) {
        Collection<T> list = map.get(name);
        if (list == null) {
            list = new ArrayList<T>();
            map.put(name, list);
        }
        list.add(value);
    }

    @Override
    public Collection<IPackageCoverage> getPackages() {
        return this.packages;
    }
}

