/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.third_party.kotlin.reflect.jvm.internal.impl.descriptors.impl;

import com.code_intelligence.jazzer.third_party.kotlin.collections.CollectionsKt;
import com.code_intelligence.jazzer.third_party.kotlin.collections.SetsKt;
import com.code_intelligence.jazzer.third_party.kotlin.jvm.functions.Function1;
import com.code_intelligence.jazzer.third_party.kotlin.jvm.internal.Intrinsics;
import com.code_intelligence.jazzer.third_party.kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import com.code_intelligence.jazzer.third_party.kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import com.code_intelligence.jazzer.third_party.kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import com.code_intelligence.jazzer.third_party.kotlin.reflect.jvm.internal.impl.name.FqName;
import com.code_intelligence.jazzer.third_party.kotlin.reflect.jvm.internal.impl.name.Name;
import com.code_intelligence.jazzer.third_party.kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindExclude;
import com.code_intelligence.jazzer.third_party.kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import com.code_intelligence.jazzer.third_party.kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScopeImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubpackagesScope
extends MemberScopeImpl {
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final FqName fqName;

    public SubpackagesScope(@NotNull ModuleDescriptor moduleDescriptor, @NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        this.moduleDescriptor = moduleDescriptor;
        this.fqName = fqName2;
    }

    @Nullable
    protected final PackageViewDescriptor getPackage(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        if (name.isSpecial()) {
            return null;
        }
        FqName fqName2 = this.fqName.child(name);
        Intrinsics.checkNotNullExpressionValue(fqName2, "fqName.child(name)");
        PackageViewDescriptor packageViewDescriptor = this.moduleDescriptor.getPackage(fqName2);
        if (packageViewDescriptor.isEmpty()) {
            return null;
        }
        return packageViewDescriptor;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkNotNullParameter(kindFilter, "kindFilter");
        Intrinsics.checkNotNullParameter(nameFilter, "nameFilter");
        if (!kindFilter.acceptsKinds(DescriptorKindFilter.Companion.getPACKAGES_MASK())) {
            return CollectionsKt.emptyList();
        }
        if (this.fqName.isRoot() && kindFilter.getExcludes().contains(DescriptorKindExclude.TopLevelPackages.INSTANCE)) {
            return CollectionsKt.emptyList();
        }
        Collection<FqName> subFqNames = this.moduleDescriptor.getSubPackagesOf(this.fqName, nameFilter);
        ArrayList result = new ArrayList(subFqNames.size());
        for (FqName subFqName : subFqNames) {
            Name shortName;
            Intrinsics.checkNotNullExpressionValue(subFqName.shortName(), "subFqName.shortName()");
            if (!nameFilter.invoke(shortName).booleanValue()) continue;
            com.code_intelligence.jazzer.third_party.kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.addIfNotNull(result, this.getPackage(shortName));
        }
        return result;
    }

    @Override
    @NotNull
    public Set<Name> getClassifierNames() {
        return SetsKt.emptySet();
    }

    @NotNull
    public String toString() {
        return "subpackages of " + this.fqName + " from " + this.moduleDescriptor;
    }
}

