/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.third_party.com.github.fmeum.rules_jni;

final class EnvironmentUtils {
    public static final String JAVA_VENDOR = System.getProperty("java.vendor", "");
    public static final boolean IS_ANDROID = EnvironmentUtils.isAndroid(JAVA_VENDOR);
    public static final String VERBOSE_OS = System.getProperty("os.name");
    public static final String CANONICAL_OS = EnvironmentUtils.toCanonicalOs(VERBOSE_OS, JAVA_VENDOR);
    public static final String VERBOSE_CPU = System.getProperty("os.arch");
    public static final String CANONICAL_CPU = EnvironmentUtils.toCanonicalCpu(VERBOSE_CPU);

    private EnvironmentUtils() {
    }

    private static boolean isAndroid(String javaVendor) {
        return javaVendor.contains("Android");
    }

    private static String toCanonicalOs(String verboseOs, String javaVendor) {
        if (verboseOs.startsWith("Mac OS X")) {
            return "macos";
        }
        if (verboseOs.startsWith("FreeBSD")) {
            return "freebsd";
        }
        if (verboseOs.startsWith("OpenBSD")) {
            return "openbsd";
        }
        if (verboseOs.startsWith("Linux")) {
            return javaVendor.contains("Android") ? "android" : "linux";
        }
        if (verboseOs.startsWith("Windows")) {
            return "windows";
        }
        return "unknown";
    }

    private static String toCanonicalCpu(String verboseCpu) {
        switch (verboseCpu) {
            case "i386": 
            case "i486": 
            case "i586": 
            case "i686": 
            case "i786": 
            case "x86": {
                return "x86_32";
            }
            case "amd64": 
            case "x86_64": 
            case "x64": {
                return "x86_64";
            }
            case "ppc": 
            case "ppc64": 
            case "ppc64le": {
                return "ppc";
            }
            case "arm": 
            case "armv7l": {
                return "arm";
            }
            case "aarch64": {
                return "aarch64";
            }
            case "s390x": 
            case "s390": {
                return "s390x";
            }
            case "mips64el": 
            case "mips64": {
                return "mips64";
            }
            case "riscv64": {
                return "riscv64";
            }
        }
        return "unknown";
    }
}

