/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.support;

import com.code_intelligence.jazzer.mutation.annotation.NotNull;
import com.code_intelligence.jazzer.mutation.annotation.WithLength;
import com.code_intelligence.jazzer.mutation.support.Preconditions;
import com.code_intelligence.jazzer.mutation.support.TypeHolder;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class TypeSupport {
    private static final Annotation NOT_NULL = new TypeHolder<String>(){}.annotatedType().getAnnotation(NotNull.class);

    private TypeSupport() {
    }

    public static boolean isPrimitive(AnnotatedType type2) {
        return TypeSupport.isPrimitive(type2.getType());
    }

    public static boolean isPrimitive(Type type2) {
        if (!(type2 instanceof Class)) {
            return false;
        }
        return ((Class)type2).isPrimitive();
    }

    public static boolean isInheritable(Annotation annotation) {
        return annotation.annotationType().getDeclaredAnnotation(Inherited.class) != null;
    }

    public static <T> Optional<Class<? extends T>> asSubclassOrEmpty(AnnotatedType type2, Class<T> superclass) {
        if (!(type2.getType() instanceof Class)) {
            return Optional.empty();
        }
        Class actualClazz = (Class)type2.getType();
        if (!superclass.isAssignableFrom(actualClazz)) {
            return Optional.empty();
        }
        return Optional.of(actualClazz.asSubclass(superclass));
    }

    public static AnnotatedType asAnnotatedType(final Class<?> clazz) {
        Objects.requireNonNull(clazz);
        return new AnnotatedType(){

            @Override
            public Type getType() {
                return clazz;
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return (T)TypeSupport.annotatedElementGetAnnotation(this, annotationClass);
            }

            @Override
            public Annotation[] getAnnotations() {
                if (clazz.getSuperclass() == null) {
                    return new Annotation[0];
                }
                return (Annotation[])Arrays.stream(clazz.getSuperclass().getAnnotations()).filter(TypeSupport::isInheritable).toArray(Annotation[]::new);
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return new Annotation[0];
            }

            public String toString() {
                return TypeSupport.annotatedTypeToString(this);
            }

            public int hashCode() {
                throw new UnsupportedOperationException("hashCode() is not supported as its behavior isn't specified");
            }

            public boolean equals(Object obj) {
                throw new UnsupportedOperationException("equals() is not supported as its behavior isn't specified");
            }
        };
    }

    public static void visitAnnotatedType(AnnotatedType type2, BiConsumer<Class<?>, Annotation[]> visitor2) {
        TypeSupport.visitAnnotatedTypeInternal(type2, visitor2);
    }

    private static Class<?> visitAnnotatedTypeInternal(AnnotatedType type2, BiConsumer<Class<?>, Annotation[]> visitor2) {
        Class clazz;
        if (type2 instanceof AnnotatedWildcardType) {
            throw new IllegalArgumentException("Wildcard types are not supported: " + type2);
        }
        if (type2 instanceof AnnotatedTypeVariable) {
            throw new IllegalArgumentException("Type variables are not supported: " + type2);
        }
        if (type2 instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType annotatedParameterizedType = (AnnotatedParameterizedType)type2;
            Preconditions.check(annotatedParameterizedType.getType() instanceof ParameterizedType);
            Type rawType = ((ParameterizedType)annotatedParameterizedType.getType()).getRawType();
            Preconditions.check(rawType instanceof Class);
            clazz = (Class)rawType;
            visitor2.accept(clazz, type2.getDeclaredAnnotations());
            for (AnnotatedType typeArgument : annotatedParameterizedType.getAnnotatedActualTypeArguments()) {
                TypeSupport.visitAnnotatedTypeInternal(typeArgument, visitor2);
            }
        } else if (type2 instanceof AnnotatedArrayType) {
            AnnotatedArrayType arrayType = (AnnotatedArrayType)type2;
            Class<?> componentClass = TypeSupport.visitAnnotatedTypeInternal(arrayType.getAnnotatedGenericComponentType(), (c, a) -> {});
            clazz = Array.newInstance(componentClass, 0).getClass();
            visitor2.accept(clazz, type2.getDeclaredAnnotations());
            TypeSupport.visitAnnotatedTypeInternal(arrayType.getAnnotatedGenericComponentType(), visitor2);
        } else {
            Preconditions.check(type2.getType() instanceof Class);
            clazz = (Class)type2.getType();
            visitor2.accept(clazz, type2.getDeclaredAnnotations());
        }
        return clazz;
    }

    public static AnnotatedType notNull(AnnotatedType type2) {
        return TypeSupport.withExtraAnnotations(type2, NOT_NULL);
    }

    public static AnnotatedType withLength(AnnotatedType type2, int min, int max) {
        WithLength withLength = TypeSupport.withLengthImplementation(min, max);
        return TypeSupport.withExtraAnnotations(type2, withLength);
    }

    private static WithLength withLengthImplementation(final int min, final int max) {
        return new WithLength(){

            @Override
            public int min() {
                return min;
            }

            @Override
            public int max() {
                return max;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return WithLength.class;
            }

            @Override
            public boolean equals(Object o) {
                if (!(o instanceof WithLength)) {
                    return false;
                }
                WithLength other = (WithLength)o;
                return this.min() == other.min() && this.max() == other.max();
            }

            @Override
            public int hashCode() {
                int hash = 0;
                hash += "min".hashCode() * 127 ^ Integer.valueOf(this.min()).hashCode();
                return hash += "max".hashCode() * 127 ^ Integer.valueOf(this.max()).hashCode();
            }
        };
    }

    public static AnnotatedParameterizedType withTypeArguments(final AnnotatedType type2, final AnnotatedType ... typeArguments) {
        Objects.requireNonNull(type2);
        Preconditions.requireNonNullElements(typeArguments);
        Preconditions.require(typeArguments.length > 0);
        Preconditions.require(!(type2 instanceof AnnotatedParameterizedType) && !(type2 instanceof AnnotatedTypeVariable) && !(type2 instanceof AnnotatedWildcardType) && !(type2 instanceof AnnotatedArrayType), "only plain annotated types are supported");
        Preconditions.require(((Class)type2.getType()).getEnclosingClass() == null, "nested classes aren't supported");
        final ParameterizedType filledRawType = new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return (Type[])Arrays.stream(typeArguments).map(AnnotatedType::getType).toArray(Type[]::new);
            }

            @Override
            public Type getRawType() {
                return type2.getType();
            }

            @Override
            public Type getOwnerType() {
                return null;
            }

            public String toString() {
                return this.getRawType() + Arrays.stream(this.getActualTypeArguments()).map(Object::toString).collect(Collectors.joining(",", "<", ">"));
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof ParameterizedType)) {
                    return false;
                }
                ParameterizedType other = (ParameterizedType)obj;
                return this.getRawType().equals(other.getRawType()) && null == other.getOwnerType() && Arrays.equals(this.getActualTypeArguments(), other.getActualTypeArguments());
            }

            public int hashCode() {
                throw new UnsupportedOperationException("hashCode() is not supported as its behavior isn't specified");
            }
        };
        return new AnnotatedParameterizedType(){

            @Override
            public AnnotatedType[] getAnnotatedActualTypeArguments() {
                return Arrays.copyOf(typeArguments, typeArguments.length);
            }

            @Override
            public AnnotatedType getAnnotatedOwnerType() {
                return null;
            }

            @Override
            public Type getType() {
                return filledRawType;
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return type2.getAnnotation(annotationClass);
            }

            @Override
            public Annotation[] getAnnotations() {
                return type2.getAnnotations();
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return type2.getDeclaredAnnotations();
            }

            public String toString() {
                return TypeSupport.annotatedTypeToString(this);
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof AnnotatedParameterizedType)) {
                    return false;
                }
                AnnotatedParameterizedType other = (AnnotatedParameterizedType)obj;
                return Objects.equals(this.getType(), other.getType()) && Arrays.equals(this.getAnnotatedActualTypeArguments(), other.getAnnotatedActualTypeArguments()) && Arrays.equals(this.getAnnotations(), other.getAnnotations());
            }

            public int hashCode() {
                throw new UnsupportedOperationException("hashCode() is not supported as its behavior isn't specified");
            }
        };
    }

    public static AnnotatedType withExtraAnnotations(AnnotatedType base, Annotation ... extraAnnotations) {
        Objects.requireNonNull(base);
        Preconditions.requireNonNullElements(extraAnnotations);
        if (extraAnnotations.length == 0) {
            return base;
        }
        Preconditions.require(!(base instanceof AnnotatedTypeVariable) && !(base instanceof AnnotatedWildcardType), "Adding annotations to AnnotatedTypeVariables or AnnotatedWildcardTypes is not supported");
        if (base instanceof AnnotatedArrayType) {
            return new AugmentedArrayType((AnnotatedArrayType)base, extraAnnotations);
        }
        if (base instanceof AnnotatedParameterizedType) {
            return new AugmentedParameterizedType((AnnotatedParameterizedType)base, extraAnnotations);
        }
        return new AugmentedAnnotatedType(base, extraAnnotations);
    }

    private static String annotatedTypeToString(AnnotatedType annotatedType) {
        String annotations2 = Arrays.stream(annotatedType.getAnnotations()).map(Annotation::toString).collect(Collectors.joining(" "));
        if (annotations2.isEmpty()) {
            return annotatedType.getType().toString();
        }
        return annotations2 + " " + annotatedType.getType();
    }

    private static <T extends Annotation> T annotatedElementGetAnnotation(AnnotatedElement element, Class<T> annotationClass) {
        Objects.requireNonNull(annotationClass);
        return (T)((Annotation)Arrays.stream(element.getAnnotations()).filter(annotation -> annotationClass.equals(annotation.annotationType())).findFirst().map(annotationClass::cast).orElse(null));
    }

    public static Optional<Class<?>> findFirstParentIfClass(AnnotatedType type2, Class<?> ... parents) {
        if (!(type2.getType() instanceof Class)) {
            return Optional.empty();
        }
        Class clazz = (Class)type2.getType();
        return Stream.of(parents).filter(parent -> parent.isAssignableFrom(clazz)).findFirst();
    }

    public static Optional<AnnotatedType> parameterTypeIfParameterized(AnnotatedType type2, Class<?> expectedParent) {
        return TypeSupport.parameterTypesIfParameterized(type2, expectedParent).flatMap(typeArguments -> {
            if (typeArguments.size() != 1) {
                return Optional.empty();
            }
            AnnotatedType elementType = (AnnotatedType)typeArguments.get(0);
            if (!(elementType.getType() instanceof ParameterizedType) && !(elementType.getType() instanceof Class)) {
                return Optional.empty();
            }
            return Optional.of(elementType);
        });
    }

    public static Optional<List<AnnotatedType>> parameterTypesIfParameterized(AnnotatedType type2, Class<?> expectedParent) {
        if (!(type2 instanceof AnnotatedParameterizedType)) {
            return Optional.empty();
        }
        Class clazz = (Class)((ParameterizedType)type2.getType()).getRawType();
        if (!expectedParent.isAssignableFrom(clazz)) {
            return Optional.empty();
        }
        AnnotatedType[] typeArguments = ((AnnotatedParameterizedType)type2).getAnnotatedActualTypeArguments();
        if (typeArguments.length == 0) {
            return Optional.empty();
        }
        return Optional.of(Collections.unmodifiableList(Arrays.asList(typeArguments)));
    }

    public static <T> boolean containedInDirectedCycle(T root, Function<T, Stream<T>> successors) {
        Object currentNode;
        HashSet traversed = new HashSet();
        ArrayDeque<T> toTraverse = new ArrayDeque<T>();
        toTraverse.addLast(root);
        while ((currentNode = toTraverse.pollLast()) != null) {
            if (traversed.add(currentNode)) {
                successors.apply(currentNode).forEachOrdered(toTraverse::addLast);
                continue;
            }
            if (!currentNode.equals(root)) continue;
            return true;
        }
        return false;
    }

    private static class AugmentedArrayType
    extends AugmentedAnnotatedType
    implements AnnotatedArrayType {
        private AugmentedArrayType(AnnotatedArrayType base, Annotation[] extraAnnotations) {
            super(base, extraAnnotations);
        }

        @Override
        public AnnotatedType getAnnotatedGenericComponentType() {
            return ((AnnotatedArrayType)this.base).getAnnotatedGenericComponentType();
        }

        @Override
        public AnnotatedType getAnnotatedOwnerType() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    private static class AugmentedParameterizedType
    extends AugmentedAnnotatedType
    implements AnnotatedParameterizedType {
        private AugmentedParameterizedType(AnnotatedParameterizedType base, Annotation[] extraAnnotations) {
            super(base, extraAnnotations);
        }

        @Override
        public AnnotatedType[] getAnnotatedActualTypeArguments() {
            return ((AnnotatedParameterizedType)this.base).getAnnotatedActualTypeArguments();
        }

        @Override
        public AnnotatedType getAnnotatedOwnerType() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    private static class AugmentedAnnotatedType
    implements AnnotatedType {
        protected final AnnotatedType base;
        private final Annotation[] extraAnnotations;

        private AugmentedAnnotatedType(AnnotatedType base, Annotation[] extraAnnotations) {
            this.base = Objects.requireNonNull(base);
            this.extraAnnotations = AugmentedAnnotatedType.checkExtraAnnotations(base, extraAnnotations);
        }

        private static Annotation[] checkExtraAnnotations(AnnotatedElement base, Annotation[] extraAnnotations) {
            Preconditions.requireNonNullElements(extraAnnotations);
            Set existingAnnotationTypes = Arrays.stream(base.getDeclaredAnnotations()).map(Annotation::annotationType).collect(Collectors.toCollection(HashSet::new));
            for (Annotation annotation : extraAnnotations) {
                boolean added = existingAnnotationTypes.add(annotation.annotationType());
                Preconditions.require(added, annotation + " already directly present on " + base);
            }
            return extraAnnotations;
        }

        @Override
        public Type getType() {
            return this.base.getType();
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return (T)TypeSupport.annotatedElementGetAnnotation(this, annotationClass);
        }

        @Override
        public Annotation[] getAnnotations() {
            Set directlyPresentTypes = Arrays.stream(this.getDeclaredAnnotations()).map(Annotation::annotationType).collect(Collectors.toSet());
            return (Annotation[])Stream.concat(Arrays.stream(this.getDeclaredAnnotations()), Arrays.stream(this.base.getAnnotations()).filter(annotation -> !directlyPresentTypes.contains(annotation.annotationType()))).toArray(Annotation[]::new);
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return (Annotation[])Stream.concat(Arrays.stream(this.base.getDeclaredAnnotations()), Arrays.stream(this.extraAnnotations)).toArray(Annotation[]::new);
        }

        public String toString() {
            return TypeSupport.annotatedTypeToString(this);
        }

        public boolean equals(Object obj) {
            throw new UnsupportedOperationException("equals() is not supported as its behavior isn't specified");
        }

        public int hashCode() {
            throw new UnsupportedOperationException("hashCode() is not supported as its behavior isn't specified");
        }
    }
}

