/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.lang;

import com.code_intelligence.jazzer.mutation.annotation.Ascii;
import com.code_intelligence.jazzer.mutation.annotation.WithUtf8Length;
import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.combinator.MutatorCombinators;
import com.code_intelligence.jazzer.mutation.support.TypeSupport;
import java.lang.reflect.AnnotatedType;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

final class StringMutatorFactory
extends MutatorFactory {
    private static final int HEADER_MASK = 192;
    private static final int BODY_MASK = 63;
    private static final int CONTINUATION_HEADER = 128;
    private static final int DEFAULT_MIN_BYTES = 0;
    private static final int DEFAULT_MAX_BYTES = 1000;

    StringMutatorFactory() {
    }

    static void fixUpAscii(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            int n = i++;
            bytes[n] = (byte)(bytes[n] & 0x7F);
        }
    }

    static void fixUpUtf8(byte[] bytes) {
        int pos = 0;
        while (pos < bytes.length) {
            byte b;
            int scanPos;
            int maxScanPos = Math.min(pos + 4, bytes.length);
            int codePoint = bytes[pos] & 0xFF;
            for (scanPos = pos + 1; scanPos < maxScanPos && ((b = bytes[scanPos]) & 0xC0) == 128; ++scanPos) {
                codePoint = (codePoint << 6) + (b & 0x3F);
            }
            int size = scanPos - pos;
            int nextPos = scanPos;
            switch (size) {
                case 1: {
                    bytes[pos] = (byte)(codePoint &= 0x7F);
                    break;
                }
                case 2: {
                    if ((codePoint &= 0x7FF) <= 127) {
                        codePoint |= 0x80;
                    }
                    bytes[--scanPos] = (byte)(0x80 | codePoint & 0x3F);
                    bytes[pos] = (byte)(0xC0 | (codePoint >>= 6));
                    break;
                }
                case 3: {
                    if ((codePoint &= 0xFFFF) <= 2047) {
                        codePoint |= 0x800;
                    }
                    if (codePoint >= 55296 && codePoint <= 57343) {
                        codePoint |= codePoint & 0xFFFF0FFF | 0xE000;
                    }
                    bytes[--scanPos] = (byte)(0x80 | codePoint & 0x3F);
                    bytes[--scanPos] = (byte)(0x80 | (codePoint >>= 6) & 0x3F);
                    bytes[pos] = (byte)(0xE0 | (codePoint >>= 6));
                    break;
                }
                case 4: {
                    if ((codePoint &= 0x1FFFFF) <= 65535) {
                        codePoint |= 0x100000;
                    }
                    if (codePoint > 0x10FFFF) {
                        codePoint &= 0xFFEF0000;
                    }
                    bytes[--scanPos] = (byte)(0x80 | codePoint & 0x3F);
                    bytes[--scanPos] = (byte)(0x80 | (codePoint >>= 6) & 0x3F);
                    bytes[--scanPos] = (byte)(0x80 | (codePoint >>= 6) & 0x3F);
                    bytes[pos] = (byte)(0xF0 | (codePoint >>= 6));
                    break;
                }
                default: {
                    throw new IllegalStateException("Not reached as scanPos <= pos + 4");
                }
            }
            pos = nextPos;
        }
    }

    @Override
    public Optional<SerializingMutator<?>> tryCreate(AnnotatedType type2, MutatorFactory factory) {
        Optional<WithUtf8Length> utf8Length = Optional.ofNullable(type2.getAnnotation(WithUtf8Length.class));
        int min = utf8Length.map(WithUtf8Length::min).orElse(0);
        int max = utf8Length.map(WithUtf8Length::max).orElse(1000);
        AnnotatedType innerByteArray = TypeSupport.notNull(TypeSupport.withLength(TypeSupport.asAnnotatedType(byte[].class), min, max));
        return TypeSupport.findFirstParentIfClass(type2, String.class).flatMap(parent -> factory.tryCreate(innerByteArray)).map(byteArrayMutator -> {
            boolean fixUpAscii = type2.getDeclaredAnnotation(Ascii.class) != null;
            return MutatorCombinators.mutateThenMapToImmutable(byteArrayMutator, bytes -> {
                if (fixUpAscii) {
                    StringMutatorFactory.fixUpAscii(bytes);
                } else {
                    StringMutatorFactory.fixUpUtf8(bytes);
                }
                return new String((byte[])bytes, StandardCharsets.UTF_8);
            }, string -> string.getBytes(StandardCharsets.UTF_8), inCycle -> "String");
        });
    }
}

