/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.collection;

import com.code_intelligence.jazzer.mutation.api.PseudoRandom;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class ChunkCrossOvers {
    private ChunkCrossOvers() {
    }

    static <T> void insertChunk(List<T> list, List<T> otherList, int maxSize, PseudoRandom prng, boolean hasFixedSize) {
        int maxChunkSize = Math.min(maxSize - list.size(), otherList.size());
        int chunkSize = prng.sizeInClosedRange(1, maxChunkSize, hasFixedSize);
        int fromPos = prng.closedRange(0, otherList.size() - chunkSize);
        int toPos = prng.closedRange(0, list.size());
        List<T> chunk = otherList.subList(fromPos, fromPos + chunkSize);
        list.addAll(toPos, chunk);
    }

    static <T> void overwriteChunk(List<T> list, List<T> otherList, PseudoRandom prng, boolean hasFixedSize) {
        ChunkCrossOvers.onCorrespondingChunks(list, otherList, prng, list::set, hasFixedSize);
    }

    static <T> void crossOverChunk(List<T> list, List<T> otherList, SerializingMutator<T> elementMutator, PseudoRandom prng) {
        ChunkCrossOvers.onCorrespondingChunks(list, otherList, prng, (int toPos, T element) -> list.set(toPos, elementMutator.crossOver(list.get(toPos), element, prng)), elementMutator.hasFixedSize());
    }

    private static <T> void onCorrespondingChunks(List<T> list, List<T> otherList, PseudoRandom prng, ChunkListElementOperation<T> operation, boolean hasFixedSize) {
        int maxChunkSize = Math.min(list.size(), otherList.size());
        int chunkSize = prng.sizeInClosedRange(1, maxChunkSize, hasFixedSize);
        int fromPos = prng.closedRange(0, otherList.size() - chunkSize);
        int toPos = prng.closedRange(0, list.size() - chunkSize);
        List<T> chunk = otherList.subList(fromPos, fromPos + chunkSize);
        for (int i = 0; i < chunk.size(); ++i) {
            operation.apply(toPos + i, chunk.get(i));
        }
    }

    static <K, V> void insertChunk(Map<K, V> map, Map<K, V> otherMap, int maxSize, PseudoRandom prng, boolean hasFixedSize) {
        int originalSize = map.size();
        int maxChunkSize = Math.min(maxSize - originalSize, otherMap.size());
        int chunkSize = prng.sizeInClosedRange(1, maxChunkSize, hasFixedSize);
        int fromChunkOffset = prng.closedRange(0, otherMap.size() - chunkSize);
        Iterator<Map.Entry<K, V>> fromIterator = otherMap.entrySet().iterator();
        for (int i = 0; i < fromChunkOffset; ++i) {
            fromIterator.next();
        }
        while (map.size() < originalSize + chunkSize && fromIterator.hasNext()) {
            Map.Entry<K, V> entry = fromIterator.next();
            if (map.containsKey(entry.getKey())) continue;
            map.put(entry.getKey(), entry.getValue());
        }
    }

    static <K, V> void overwriteChunk(Map<K, V> map, Map<K, V> otherMap, PseudoRandom prng, boolean hasFixedSize) {
        ChunkCrossOvers.onCorrespondingChunks(map, otherMap, prng, (Iterator<Map.Entry<K, V>> fromIterator, Iterator<Map.Entry<K, V>> toIterator, int chunkSize) -> {
            for (int i = 0; i < chunkSize; ++i) {
                Map.Entry from = (Map.Entry)fromIterator.next();
                Map.Entry to = (Map.Entry)toIterator.next();
                to.setValue(from.getValue());
            }
        }, hasFixedSize);
    }

    static <K, V> void crossOverChunk(Map<K, V> map, Map<K, V> otherMap, SerializingMutator<K> keyMutator, SerializingMutator<V> valueMutator, PseudoRandom prng) {
        if (prng.choice()) {
            ChunkCrossOvers.crossOverChunkKeys(map, otherMap, keyMutator, prng);
        } else {
            ChunkCrossOvers.crossOverChunkValues(map, otherMap, valueMutator, prng);
        }
    }

    private static <K, V> void crossOverChunkKeys(Map<K, V> map, Map<K, V> otherMap, SerializingMutator<K> keyMutator, PseudoRandom prng) {
        ChunkCrossOvers.onCorrespondingChunks(map, otherMap, prng, (Iterator<Map.Entry<K, V>> fromIterator, Iterator<Map.Entry<K, V>> toIterator, int chunkSize) -> {
            LinkedHashMap entriesToAdd = new LinkedHashMap(chunkSize);
            for (int i = 0; i < chunkSize; ++i) {
                Map.Entry to = (Map.Entry)toIterator.next();
                Map.Entry from = (Map.Entry)fromIterator.next();
                Object key = to.getKey();
                Object value = to.getValue();
                toIterator.remove();
                Object newKey = keyMutator.crossOver(key, from.getKey(), prng);
                if (newKey == null) continue;
                entriesToAdd.put(newKey, value);
            }
            map.putAll(entriesToAdd);
        }, keyMutator.hasFixedSize());
    }

    private static <K, V> void crossOverChunkValues(Map<K, V> map, Map<K, V> otherMap, SerializingMutator<V> valueMutator, PseudoRandom prng) {
        ChunkCrossOvers.onCorrespondingChunks(map, otherMap, prng, (Iterator<Map.Entry<K, V>> fromIterator, Iterator<Map.Entry<K, V>> toIterator, int chunkSize) -> {
            for (int i = 0; i < chunkSize; ++i) {
                Map.Entry fromEntry = (Map.Entry)fromIterator.next();
                Map.Entry toEntry = (Map.Entry)toIterator.next();
                Object newValue = valueMutator.crossOver(toEntry.getValue(), fromEntry.getValue(), prng);
                toEntry.setValue(newValue);
            }
        }, valueMutator.hasFixedSize());
    }

    static <K, V> void onCorrespondingChunks(Map<K, V> map, Map<K, V> otherMap, PseudoRandom prng, ChunkMapOperation<K, V> operation, boolean hasFixedSize) {
        int maxChunkSize = Math.min(map.size(), otherMap.size());
        int chunkSize = prng.sizeInClosedRange(1, maxChunkSize, hasFixedSize);
        int fromChunkOffset = prng.closedRange(0, otherMap.size() - chunkSize);
        int toChunkOffset = prng.closedRange(0, map.size() - chunkSize);
        Iterator<Map.Entry<K, V>> fromIterator = otherMap.entrySet().iterator();
        for (int i = 0; i < fromChunkOffset; ++i) {
            fromIterator.next();
        }
        Iterator<Map.Entry<K, V>> toIterator = map.entrySet().iterator();
        for (int i = 0; i < toChunkOffset; ++i) {
            toIterator.next();
        }
        operation.apply(fromIterator, toIterator, chunkSize);
    }

    @FunctionalInterface
    private static interface ChunkListElementOperation<T> {
        public void apply(int var1, T var2);
    }

    @FunctionalInterface
    private static interface ChunkMapOperation<K, V> {
        public void apply(Iterator<Map.Entry<K, V>> var1, Iterator<Map.Entry<K, V>> var2, int var3);
    }

    public static enum CrossOverAction {
        INSERT_CHUNK,
        OVERWRITE_CHUNK,
        CROSS_OVER_CHUNK,
        NOOP;


        public static CrossOverAction pickRandomCrossOverAction(Collection<?> reference, Collection<?> otherReference, int maxSize, PseudoRandom prng) {
            ArrayList<CrossOverAction> actions = new ArrayList<CrossOverAction>();
            if (reference.size() < maxSize && !otherReference.isEmpty()) {
                actions.add(INSERT_CHUNK);
            }
            if (!reference.isEmpty() && !otherReference.isEmpty()) {
                actions.add(OVERWRITE_CHUNK);
                actions.add(CROSS_OVER_CHUNK);
            }
            if (actions.isEmpty()) {
                return NOOP;
            }
            return (CrossOverAction)((Object)prng.pickIn(actions));
        }
    }
}

