/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.driver;

import com.code_intelligence.jazzer.api.FuzzedDataProvider;
import com.code_intelligence.jazzer.autofuzz.FuzzTarget;
import com.code_intelligence.jazzer.driver.ExceptionUtils;
import com.code_intelligence.jazzer.driver.FuzzTargetHolder;
import com.code_intelligence.jazzer.driver.FuzzedDataProviderImpl;
import com.code_intelligence.jazzer.driver.LifecycleMethodsInvoker;
import com.code_intelligence.jazzer.driver.Opt;
import com.code_intelligence.jazzer.driver.RecordingFuzzedDataProvider;
import com.code_intelligence.jazzer.driver.ReproducerTemplate;
import com.code_intelligence.jazzer.driver.SignalHandler;
import com.code_intelligence.jazzer.instrumentor.CoverageRecorder;
import com.code_intelligence.jazzer.mutation.ArgumentsMutator;
import com.code_intelligence.jazzer.runtime.Constants;
import com.code_intelligence.jazzer.runtime.FuzzTargetRunnerNatives;
import com.code_intelligence.jazzer.runtime.JazzerInternal;
import com.code_intelligence.jazzer.utils.Log;
import com.code_intelligence.jazzer.utils.UnsafeProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import sun.misc.Unsafe;

public final class FuzzTargetRunner {
    private static final String OPENTEST4J_TEST_ABORTED_EXCEPTION = "org.opentest4j.TestAbortedException";
    private static final Unsafe UNSAFE;
    private static final long BYTE_ARRAY_OFFSET;
    private static final int LIBFUZZER_CONTINUE = 0;
    private static final int LIBFUZZER_RETURN_FROM_DRIVER = -2;
    private static final Set<Long> ignoredTokens;
    private static final boolean useExperimentalMutator;
    private static final boolean optimizeMergeInner;
    private static final boolean useHooks;
    private static final boolean emitDedupToken;
    private static final long keepGoing;
    private static final long crossOverFrequency;
    private static final FuzzedDataProviderImpl fuzzedDataProvider;
    private static final MethodHandle fuzzTargetMethod;
    private static final LifecycleMethodsInvoker lifecycleMethodsInvoker;
    private static final boolean useFuzzedDataProvider;
    private static final ArgumentsMutator mutator;
    private static final ReproducerTemplate reproducerTemplate;
    private static Consumer<Throwable> fatalFindingHandlerForJUnit;
    private static long crossOverCount;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int runOne(byte[] data2) {
        long dataPtr = UNSAFE.allocateMemory(data2.length);
        UNSAFE.copyMemory(data2, BYTE_ARRAY_OFFSET, null, dataPtr, data2.length);
        try {
            int n = FuzzTargetRunner.runOne(dataPtr, data2.length);
            return n;
        }
        finally {
            UNSAFE.freeMemory(dataPtr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runOne(long dataPtr, int dataLength) {
        boolean isFuzzingFromCommandLine;
        long dedupToken;
        Object argument;
        byte[] data2;
        Throwable finding = null;
        if (useExperimentalMutator) {
            byte[] buf = FuzzTargetRunner.copyToArray(dataPtr, dataLength);
            mutator.read(new ByteArrayInputStream(buf));
            data2 = null;
            argument = null;
        } else if (useFuzzedDataProvider) {
            fuzzedDataProvider.setNativeData(dataPtr, dataLength);
            data2 = null;
            argument = fuzzedDataProvider;
        } else {
            argument = data2 = FuzzTargetRunner.copyToArray(dataPtr, dataLength);
        }
        try {
            lifecycleMethodsInvoker.beforeEachExecution();
        }
        catch (Throwable uncaughtFinding) {
            finding = uncaughtFinding;
        }
        if (finding == null) {
            try {
                Object fuzzTargetInstance = lifecycleMethodsInvoker.getTestClassInstance();
                if (useExperimentalMutator) {
                    mutator.invoke(fuzzTargetInstance, false);
                } else if (fuzzTargetInstance == null) {
                    fuzzTargetMethod.invoke(argument);
                } else {
                    fuzzTargetMethod.invoke(fuzzTargetInstance, argument);
                }
            }
            catch (Throwable uncaughtFinding) {
                finding = uncaughtFinding;
            }
            finally {
                try {
                    lifecycleMethodsInvoker.afterEachExecution();
                }
                catch (Throwable t) {
                    if (finding != null) {
                        Log.warn("Failed to run lifecycle method", t);
                    }
                    finding = t;
                }
            }
        }
        if (optimizeMergeInner) {
            return 0;
        }
        if (JazzerInternal.lastFinding != null) {
            finding = JazzerInternal.lastFinding;
            JazzerInternal.lastFinding = null;
        }
        if (finding == null || finding.getClass().getName().equals(OPENTEST4J_TEST_ABORTED_EXCEPTION)) {
            return 0;
        }
        FuzzTargetRunner.temporarilyDisableLibfuzzerExitHook();
        if (useHooks) {
            finding = ExceptionUtils.preprocessThrowable(finding);
        }
        long l = dedupToken = emitDedupToken ? ExceptionUtils.computeDedupToken(finding) : 0L;
        if (emitDedupToken && !ignoredTokens.add(dedupToken)) {
            return 0;
        }
        boolean continueFuzzing = emitDedupToken && Long.compareUnsigned(ignoredTokens.size(), keepGoing) < 0;
        boolean bl = isFuzzingFromCommandLine = fatalFindingHandlerForJUnit == null || Opt.isJUnitAndCommandLine.get() != false;
        if (isFuzzingFromCommandLine || continueFuzzing) {
            Log.finding(finding);
        }
        if (fatalFindingHandlerForJUnit != null && !continueFuzzing) {
            fatalFindingHandlerForJUnit.accept(finding);
        }
        if (emitDedupToken) {
            Log.structuredOutput(String.format(Locale.ROOT, "DEDUP_TOKEN: %016x", dedupToken));
        }
        if (isFuzzingFromCommandLine) {
            Log.println("== libFuzzer crashing input ==");
        }
        FuzzTargetRunner.printAndDumpCrashingInput();
        if (fatalFindingHandlerForJUnit == null && !useExperimentalMutator) {
            FuzzTargetRunner.dumpReproducer(data2);
        }
        if (!continueFuzzing) {
            if (!Opt.autofuzz.get().isEmpty() && emitDedupToken) {
                Log.println("");
                Log.info(String.format("To continue fuzzing past this particular finding, rerun with the following additional argument:%n%n    --ignore=%s%n%nTo ignore all findings of this kind, rerun with the following additional argument:%n%n    --autofuzz_ignore=%s", ignoredTokens.stream().map(token -> Long.toUnsignedString(token, 16)).collect(Collectors.joining(",")), Stream.concat(Opt.autofuzzIgnore.get().stream(), Stream.of(finding.getClass().getName())).collect(Collectors.joining(","))));
            }
            if (fatalFindingHandlerForJUnit == null) {
                System.exit(77);
            } else {
                return -2;
            }
        }
        return 0;
    }

    private static int mutateOne(long data2, int size, int maxSize, int seed) {
        FuzzTargetRunner.mutate(data2, size, seed);
        return FuzzTargetRunner.writeToMemory(mutator, data2, maxSize);
    }

    private static void mutate(long data2, int size, int seed) {
        if (size == 1 && UNSAFE.getByte(data2) == 10) {
            mutator.init(seed);
        } else {
            mutator.read(new ByteArrayInputStream(FuzzTargetRunner.copyToArray(data2, size)));
            mutator.mutate(seed);
        }
    }

    private static int crossOver(long data1, int size1, long data2, int size2, long out, int maxOutSize, int seed) {
        if (crossOverFrequency != 0L && crossOverCount++ % crossOverFrequency == 0L) {
            mutator.crossOver(new ByteArrayInputStream(FuzzTargetRunner.copyToArray(data1, size1)), new ByteArrayInputStream(FuzzTargetRunner.copyToArray(data2, size2)), seed);
        } else {
            FuzzTargetRunner.mutate(data1, size1, seed);
        }
        return FuzzTargetRunner.writeToMemory(mutator, out, maxOutSize);
    }

    private static int writeToMemory(ArgumentsMutator mutator, long out, int maxOutSize) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        mutator.write(baos);
        byte[] mutatedBytes = baos.toByteArray();
        int newSize = Math.min(mutatedBytes.length, maxOutSize);
        UNSAFE.copyMemory(mutatedBytes, BYTE_ARRAY_OFFSET, null, out, newSize);
        return newSize;
    }

    public static int startLibFuzzer(List<String> args2) {
        if (!useExperimentalMutator) {
            args2 = new ArrayList<String>(args2);
            args2.add("-len_control=100");
        }
        for (String arg : args2.subList(1, args2.size())) {
            if (arg.startsWith("-")) continue;
            Log.info("using inputs from: " + arg);
        }
        if (!Constants.IS_ANDROID) {
            SignalHandler.initialize();
        }
        return FuzzTargetRunner.startLibFuzzer((byte[][])args2.stream().map(str -> str.getBytes(StandardCharsets.UTF_8)).toArray(x$0 -> new byte[x$0][]));
    }

    public static void registerFatalFindingHandlerForJUnit(Consumer<Throwable> findingHandler) {
        fatalFindingHandlerForJUnit = Objects.requireNonNull(findingHandler);
    }

    private static void shutdown() {
        if (!Opt.coverageDump.get().isEmpty() || !Opt.coverageReport.get().isEmpty()) {
            if (!Opt.coverageDump.get().isEmpty()) {
                CoverageRecorder.dumpJacocoCoverage(Opt.coverageDump.get());
            }
            if (!Opt.coverageReport.get().isEmpty()) {
                CoverageRecorder.dumpCoverageReport(Opt.coverageReport.get());
            }
        }
        try {
            lifecycleMethodsInvoker.afterLastExecution();
        }
        catch (Throwable t) {
            Log.finding(t);
            System.exit(77);
        }
    }

    private static void dumpReproducer(byte[] data2) {
        String base64Data;
        MessageDigest digest;
        if (data2 == null) {
            if (!$assertionsDisabled && !useFuzzedDataProvider) {
                throw new AssertionError();
            }
            fuzzedDataProvider.reset();
            data2 = fuzzedDataProvider.consumeRemainingAsBytes();
        }
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-1 not available", e);
        }
        String dataSha1 = FuzzTargetRunner.toHexString(digest.digest(data2));
        if (!Opt.autofuzz.get().isEmpty()) {
            fuzzedDataProvider.reset();
            FuzzTarget.dumpReproducer(fuzzedDataProvider, Opt.reproducerPath.get(), dataSha1);
            return;
        }
        if (useFuzzedDataProvider) {
            fuzzedDataProvider.reset();
            FuzzedDataProvider recordingFuzzedDataProvider = RecordingFuzzedDataProvider.makeFuzzedDataProviderProxy(fuzzedDataProvider);
            try {
                fuzzTargetMethod.invokeExact(recordingFuzzedDataProvider);
                if (JazzerInternal.lastFinding == null) {
                    Log.warn("Failed to reproduce crash when rerunning with recorder");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                base64Data = RecordingFuzzedDataProvider.serializeFuzzedDataProviderProxy(recordingFuzzedDataProvider);
            }
            catch (IOException e) {
                Log.error("Failed to create reproducer", e);
                System.exit(1);
                throw new IllegalStateException("Not reached");
            }
        }
        base64Data = Base64.getEncoder().encodeToString(data2);
        reproducerTemplate.dumpReproducer(base64Data, dataSha1);
    }

    private static String toHexString(byte[] bytes) {
        String unpadded = new BigInteger(1, bytes).toString(16);
        int numLeadingZeroes = 2 * bytes.length - unpadded.length();
        return String.join((CharSequence)"", Collections.nCopies(numLeadingZeroes, "0")) + unpadded;
    }

    private static void dumpAllStackTraces() {
        ExceptionUtils.dumpAllStackTraces();
    }

    private static byte[] copyToArray(long ptr, int length) {
        byte[] array = new byte[length];
        UNSAFE.copyMemory(null, ptr, array, BYTE_ARRAY_OFFSET, length);
        return array;
    }

    private static int startLibFuzzer(byte[][] args2) {
        return FuzzTargetRunnerNatives.startLibFuzzer((byte[][])args2, FuzzTargetRunner.class, (boolean)useExperimentalMutator);
    }

    public static void printAndDumpCrashingInput() {
        FuzzTargetRunnerNatives.printAndDumpCrashingInput();
    }

    public static String mutatorDebugString() {
        return mutator != null ? mutator.toString() : null;
    }

    private static void temporarilyDisableLibfuzzerExitHook() {
        FuzzTargetRunnerNatives.temporarilyDisableLibfuzzerExitHook();
    }

    static {
        boolean bl = $assertionsDisabled = !FuzzTargetRunner.class.desiredAssertionStatus();
        if (Opt.autofuzz.get().isEmpty()) {
            if (!Opt.autofuzzIgnore.get().isEmpty()) {
                Log.error("--autofuzz_ignore requires --autofuzz");
                System.exit(1);
            }
        } else {
            if (!Opt.targetClass.get().isEmpty()) {
                Log.error("--target_class and --autofuzz cannot be specified together");
                System.exit(1);
            }
            if (!Opt.targetArgs.setIfDefault(Collections.unmodifiableList(Stream.concat(Stream.of(Opt.autofuzz.get()), Opt.autofuzzIgnore.get().stream()).collect(Collectors.toList())))) {
                Log.error("--target_args and --autofuzz cannot be specified together");
                System.exit(1);
            }
        }
        Opt.dedup.setIfDefault(Opt.hooks.get());
        if (!(Opt.ignore.get().isEmpty() && Opt.keepGoing.get() <= 1L || Opt.dedup.get().booleanValue())) {
            Log.error("--nodedup is not supported with --ignore or --keep_going");
            System.exit(1);
        }
        UNSAFE = UnsafeProvider.getUnsafe();
        BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
        ignoredTokens = Opt.ignore.get().stream().map(s -> Long.parseUnsignedLong(s, 16)).collect(Collectors.toCollection(HashSet::new));
        useExperimentalMutator = Opt.experimentalMutator.get();
        optimizeMergeInner = Opt.mergeInner.get();
        useHooks = Opt.hooks.get();
        emitDedupToken = Opt.dedup.get();
        keepGoing = Opt.keepGoing.get();
        crossOverFrequency = Opt.experimentalCrossOverFrequency.get();
        fuzzedDataProvider = FuzzedDataProviderImpl.withNativeData();
        FuzzTargetHolder.FuzzTarget fuzzTarget = FuzzTargetHolder.fuzzTarget;
        lifecycleMethodsInvoker = fuzzTarget.lifecycleMethodsInvoker;
        fuzzTarget.method.setAccessible(true);
        try {
            fuzzTargetMethod = MethodHandles.lookup().unreflect(fuzzTarget.method);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        useFuzzedDataProvider = fuzzTarget.usesFuzzedDataProvider();
        if (!useFuzzedDataProvider && Constants.IS_ANDROID) {
            Log.error("Android fuzz targets must use " + FuzzedDataProvider.class.getName());
            System.exit(1);
        }
        Class<?> fuzzTargetClass = fuzzTarget.method.getDeclaringClass();
        reproducerTemplate = new ReproducerTemplate(fuzzTargetClass.getName(), useFuzzedDataProvider);
        JazzerInternal.onFuzzTargetReady((String)fuzzTargetClass.getName());
        try {
            lifecycleMethodsInvoker.beforeFirstExecution();
        }
        catch (Throwable t) {
            Log.finding(ExceptionUtils.preprocessThrowable(t));
            System.exit(1);
        }
        if (useExperimentalMutator) {
            mutator = ArgumentsMutator.forMethodOrThrow(fuzzTarget.method);
            Log.info("Using experimental mutator: " + mutator);
        } else {
            mutator = null;
        }
        if (useHooks) {
            CoverageRecorder.updateCoveredIdsWithCoverageMap();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(FuzzTargetRunner::shutdown));
        crossOverCount = 0L;
    }
}

