/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.driver;

import com.code_intelligence.jazzer.api.FuzzedDataProvider;
import com.code_intelligence.jazzer.driver.FuzzTargetHolder;
import com.code_intelligence.jazzer.driver.LibFuzzerLifecycleMethodsInvoker;
import com.code_intelligence.jazzer.driver.Opt;
import com.code_intelligence.jazzer.driver.ReflectionUtils;
import com.code_intelligence.jazzer.runtime.Constants;
import com.code_intelligence.jazzer.utils.Log;
import com.code_intelligence.jazzer.utils.ManifestUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

class FuzzTargetFinder {
    private static final String FUZZER_TEST_ONE_INPUT = "fuzzerTestOneInput";

    FuzzTargetFinder() {
    }

    static String findFuzzTargetClassName() {
        if (!Opt.targetClass.get().isEmpty()) {
            return Opt.targetClass.get();
        }
        if (Constants.IS_ANDROID) {
            return null;
        }
        return ManifestUtils.detectFuzzTargetClass();
    }

    static FuzzTargetHolder.FuzzTarget findFuzzTarget(String targetClassName) {
        Class<?> fuzzTargetClass;
        try {
            fuzzTargetClass = Class.forName(targetClassName, false, FuzzTargetFinder.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            Log.error(String.format("'%s' not found on classpath:%n%n%s%n%nAll required classes must be on the classpath specified via --cp.", targetClassName, System.getProperty("java.class.path")));
            System.exit(1);
            throw new IllegalStateException("Not reached");
        }
        return FuzzTargetFinder.findFuzzTargetByMethodName(fuzzTargetClass);
    }

    private static FuzzTargetHolder.FuzzTarget findFuzzTargetByMethodName(Class<?> clazz) {
        Method fuzzTargetMethod;
        if (Opt.experimentalMutator.get().booleanValue()) {
            List fuzzTargetMethods = Arrays.stream(clazz.getMethods()).filter(method -> FUZZER_TEST_ONE_INPUT.equals(method.getName())).filter(method -> Modifier.isStatic(method.getModifiers())).collect(Collectors.toList());
            if (fuzzTargetMethods.size() != 1) {
                throw new IllegalArgumentException(String.format("%s must define exactly one function of this form:%npublic static void fuzzerTestOneInput(...)%n", clazz.getName()));
            }
            fuzzTargetMethod = (Method)fuzzTargetMethods.get(0);
        } else {
            Optional<Method> bytesFuzzTarget = ReflectionUtils.targetPublicStaticMethod(clazz, FUZZER_TEST_ONE_INPUT, byte[].class);
            Optional<Method> dataFuzzTarget = ReflectionUtils.targetPublicStaticMethod(clazz, FUZZER_TEST_ONE_INPUT, FuzzedDataProvider.class);
            if (bytesFuzzTarget.isPresent() == dataFuzzTarget.isPresent()) {
                throw new IllegalArgumentException(String.format("%s must define exactly one of the following two functions:%npublic static void fuzzerTestOneInput(byte[] ...)%npublic static void fuzzerTestOneInput(FuzzedDataProvider ...)%nNote: Fuzz targets returning boolean are no longer supported; exceptions should be thrown instead of returning true.%nNote: When using the @FuzzTest annotation, you will need to set up JUnit 5, which can be as simple as adding a dependency on org.junit.jupiter:junit-jupiter-engine.", clazz.getName()));
            }
            fuzzTargetMethod = dataFuzzTarget.orElseGet(bytesFuzzTarget::get);
        }
        return new FuzzTargetHolder.FuzzTarget(fuzzTargetMethod, LibFuzzerLifecycleMethodsInvoker.of(clazz));
    }
}

