/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.autofuzz;

import com.code_intelligence.jazzer.third_party.io.github.classgraph.ClassInfo;
import com.code_intelligence.jazzer.third_party.org.objectweb.asm.Type;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;

class AccessibleObjectLookup {
    private static final Comparator<Class<?>> STABLE_CLASS_COMPARATOR = Comparator.comparing(Class::getName);
    private static final Comparator<Executable> STABLE_EXECUTABLE_COMPARATOR = Comparator.comparing(Executable::getName).thenComparing(executable -> {
        if (executable instanceof Method) {
            return Type.getMethodDescriptor((Method)executable);
        }
        return Type.getConstructorDescriptor((Constructor)executable);
    });
    private final Class<?> referenceClass;

    public AccessibleObjectLookup(Class<?> referenceClass) {
        this.referenceClass = referenceClass;
    }

    Class<?>[] getAccessibleClasses(Class<?> type2) {
        return (Class[])Stream.concat(Arrays.stream(type2.getDeclaredClasses()), Arrays.stream(type2.getClasses())).distinct().filter(this::isAccessible).sorted(STABLE_CLASS_COMPARATOR).toArray(Class[]::new);
    }

    Constructor<?>[] getAccessibleConstructors(Class<?> type2) {
        return (Constructor[])Stream.concat(Arrays.stream(type2.getDeclaredConstructors()), Arrays.stream(type2.getConstructors())).distinct().filter(this::isAccessible).sorted(STABLE_EXECUTABLE_COMPARATOR).filter(constructor -> {
            try {
                constructor.setAccessible(true);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }).toArray(Constructor[]::new);
    }

    Method[] getAccessibleMethods(Class<?> type2) {
        return (Method[])Stream.concat(Arrays.stream(type2.getDeclaredMethods()), Arrays.stream(type2.getMethods())).distinct().filter(this::isAccessible).sorted(STABLE_EXECUTABLE_COMPARATOR).filter(method -> {
            try {
                method.setAccessible(true);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }).toArray(Method[]::new);
    }

    boolean isAccessible(Class<?> clazz, int modifiers) {
        if (Modifier.isPublic(modifiers)) {
            return true;
        }
        if (this.referenceClass == null) {
            return false;
        }
        if (Modifier.isPrivate(modifiers)) {
            return clazz.equals(this.referenceClass);
        }
        if (Modifier.isProtected(modifiers)) {
            return clazz.isAssignableFrom(this.referenceClass);
        }
        return clazz.getPackage().equals(this.referenceClass.getPackage());
    }

    boolean isAccessible(ClassInfo clazz, int modifiers) {
        if (Modifier.isPublic(modifiers)) {
            return true;
        }
        if (this.referenceClass == null) {
            return false;
        }
        if (Modifier.isPrivate(modifiers)) {
            return clazz.getName().equals(this.referenceClass.getName());
        }
        if (Modifier.isProtected(modifiers)) {
            return this.isAssignableFrom(clazz, this.referenceClass);
        }
        return clazz.getPackageName().equals(this.referenceClass.getPackage().getName());
    }

    boolean isAssignableFrom(ClassInfo clazz, Class<?> potentialSubclass) {
        if (potentialSubclass.getName().equals(clazz.getName())) {
            return true;
        }
        if (potentialSubclass.equals(Object.class)) {
            return clazz.getName().equals(Object.class.getName());
        }
        if (potentialSubclass.getSuperclass() == null) {
            return false;
        }
        return this.isAssignableFrom(clazz, potentialSubclass.getSuperclass());
    }

    private boolean isAccessible(Executable executable) {
        return this.isAccessible(executable.getDeclaringClass(), executable.getModifiers());
    }

    private boolean isAccessible(Class<?> clazz) {
        return this.isAccessible(clazz, clazz.getModifiers());
    }
}

