/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.android;

import com.code_intelligence.jazzer.driver.Opt;
import com.code_intelligence.jazzer.runtime.Constants;
import com.code_intelligence.jazzer.third_party.com.github.fmeum.rules_jni.RulesJni;
import com.code_intelligence.jazzer.utils.Log;

public class AndroidRuntime {
    private static final String DO_NOT_INITIALIZE = "use_none";
    private static final String INIT_JAVA_ART = "use_platform_libs";
    private static final String FUZZ_DIR = "/data/fuzz/";
    private static final String PLATFORM_LIB_DIRS = ":/system/lib64/:/apex/com.android.i18n@1/lib64/";

    public static void initialize() {
        if (!Constants.IS_ANDROID) {
            return;
        }
        String androidInitOptions = Opt.androidInitOptions.get();
        if (androidInitOptions == null) {
            return;
        }
        switch (androidInitOptions) {
            case "use_platform_libs": {
                AndroidRuntime.registerNatives();
                break;
            }
            case "use_none": 
            case "": {
                Log.warn("Android Runtime (ART) is not being initialized for this fuzzer.");
                break;
            }
            default: {
                Log.error(String.format("%s is not a valid options for android_init_options. Valid Options: [use_none, use_platform_libs]", androidInitOptions));
                System.exit(1);
            }
        }
    }

    public static String getClassPathsCommand() {
        return "export CLASSPATH=" + System.getProperty("java.class.path");
    }

    public static String getLdLibraryPath() {
        String ldLibraryPath = FUZZ_DIR;
        String initOptString = Opt.androidInitOptions.get();
        if (initOptString != null && initOptString.equals(INIT_JAVA_ART)) {
            ldLibraryPath = ldLibraryPath + PLATFORM_LIB_DIRS;
        }
        return ldLibraryPath;
    }

    private static native int registerNatives();

    static {
        if (Constants.IS_ANDROID) {
            RulesJni.loadLibrary("jazzer_android_tooling", "/com/code_intelligence/jazzer/driver");
        }
    }
}

