/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.agent;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.JarFile;

final class AgentUtils {
    private static final String BOOTSTRAP_JAR = "/com/code_intelligence/jazzer/runtime/jazzer_bootstrap.jar";

    public static JarFile extractBootstrapJar() {
        JarFile jarFile;
        block9: {
            InputStream bootstrapJarStream = AgentUtils.class.getResourceAsStream(BOOTSTRAP_JAR);
            try {
                if (bootstrapJarStream == null) {
                    throw new IllegalStateException("Failed to find Jazzer agent bootstrap jar in resources");
                }
                File bootstrapJar = Files.createTempFile("jazzer-agent-", ".jar", new FileAttribute[0]).toFile();
                bootstrapJar.deleteOnExit();
                Files.copy(bootstrapJarStream, bootstrapJar.toPath(), StandardCopyOption.REPLACE_EXISTING);
                jarFile = new JarFile(bootstrapJar);
                if (bootstrapJarStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (bootstrapJarStream != null) {
                        try {
                            bootstrapJarStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to extract Jazzer agent bootstrap jar", e);
                }
            }
            bootstrapJarStream.close();
        }
        return jarFile;
    }

    private AgentUtils() {
    }
}

